<?php namespace Visiosoft\OrdersModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Anomaly\Streams\Platform\Model\Orders\OrdersPaymentReasonEntryModel;
use Visiosoft\OrdersModule\CcLog\Contract\CcLogRepositoryInterface;
use Visiosoft\OrdersModule\CcLog\CcLogRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersCcLogsEntryModel;
use Visiosoft\OrdersModule\CcLog\CcLogModel;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\OrdersModule\Listener\CreateInvoiceListener;
use Visiosoft\OrdersModule\PaymentReason\Contract\PaymentReasonRepositoryInterface;
use Visiosoft\OrdersModule\PaymentReason\PaymentReasonModel;
use Visiosoft\OrdersModule\PaymentReason\PaymentReasonRepository;
use Visiosoft\OrdersModule\RefundRequest\Contract\RefundRequestRepositoryInterface;
use Visiosoft\OrdersModule\RefundRequest\RefundRequestRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersRefundRequestEntryModel;
use Visiosoft\OrdersModule\RefundRequest\RefundRequestModel;
use Anomaly\Streams\Platform\Model\Orders\OrdersPaymentNameEntryModel;
use Visiosoft\OrdersModule\Orderpayment\Contract\OrderpaymentRepositoryInterface;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderpaymentsEntryModel;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentModel;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderdetailEntryModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Order\OrderRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderEntryModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\PaymentName\Contract\PaymentNameRepositoryInterface;
use Visiosoft\OrdersModule\PaymentName\PaymentNameModel;
use Visiosoft\OrdersModule\PaymentName\PaymentNameRepository;

class OrdersModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        OrdersModulePlugin::class
    ];

    protected $listeners = [
        OrderApproved::class => [
            CreateInvoiceListener::class
        ],
    ];

    protected $routes = [
        'admin/orders/cc_logs' => 'Visiosoft\OrdersModule\Http\Controller\Admin\CcLogsController@index',
        'admin/orders/cc_logs/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\CcLogsController@create',
        'admin/orders/cc_logs/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\CcLogsController@edit',
        'admin/orders/refund_request' => 'Visiosoft\OrdersModule\Http\Controller\Admin\RefundRequestController@index',

        // OrderController
        'sale' => [
            'middleware' => 'auth',
            'as' => 'orders::sale',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@sale',
        ],
        'sale/detail/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_detail',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@saleDetail',
        ],
        'sale/report' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_report',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@reportSales',
        ],
        'sale/addTrackingNumber' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_addTrackingNumber',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@addTrackingNumber',
        ],
        'sale/setStatus/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_setStatus',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@updateStatus'
        ],
        'purchase' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchase',
        ],
        'purchase/delivered/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase_delivered',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@orderDelivered',
        ],
        'purchase/not-delivered/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase_not_delivered',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@orderNotDelivered',
        ],
        'purchase/detail/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase_detail',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchaseDetail',
        ],
        'purchase/cancel/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::cancel',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchaseCancel',
        ],

        'order/approve/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::approve',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@approve',
        ],

        'order/reject/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::reject',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@reject',
        ],

        // Admin OrderpaymentsController
        'admin/orders/orderpayments' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@index',
        'admin/orders/orderpayments/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@create',
        'admin/orders/orderpayments/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@edit',
        'admin/ordersPayment/approve/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@approve',

        // Admin OrderdetailController
        'admin/orders/orderdetail' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@index',
        'admin/orders/orderdetail/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@create',
        'admin/orders/orderdetail/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@edit',
        'admin/orders/orderdetail/print/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@print',
        'admin/orders/orderdetail/description/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@getDescriptionModal',
        'admin/orders/orderdetail/description/{id}/post' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@addOrderDescription',

        // Admin OrderController
        'admin/orders' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@index',
        'admin/orders/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@create',
        'admin/orders/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@edit',
        'admin/orders/approve/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@approve',
        'admin/orders/reject/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@reject',
        'admin/orders/delivered/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@delivered',
        'admin/orders/print/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@print',

        // PaymentReason Controller
        'admin/orders/payment-reason' => 'Visiosoft\OrdersModule\Http\Controller\Admin\PaymentReasonController@index',

        // ApiController
        'api/orders/user-orders' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.orders::api_orders_user_orders',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\ApiController@getUserOrders',
        ],
        'ajax/purchase/refund_request' => [
            'as' => 'visiosoft.module.orders::ajax.refund_request',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\RefundRequestController@refundRequest',
        ],
        'purchase/refund_request/editStatus/{id}' => [
            'as' => 'visiosoft.module.orders::refund_request.edit_status',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\RefundRequestController@editStatus',
        ],

        // Admin ReportController
        'admin/api/orders/report/city' => 'Visiosoft\OrdersModule\Http\Controller\Admin\ReportController@city',
        'admin/api/orders/report/classified' => 'Visiosoft\OrdersModule\Http\Controller\Admin\ReportController@classified',
        'admin/api/orders/report/category' => 'Visiosoft\OrdersModule\Http\Controller\Admin\ReportController@category',
        'admin/api/orders/report/payment' => 'Visiosoft\OrdersModule\Http\Controller\Admin\ReportController@payment',
        'admin/api/orders/report/member' => 'Visiosoft\OrdersModule\Http\Controller\Admin\ReportController@member',


        //Customer
        'customer-order/detail' => [
            'as' => 'visiosoft.module.orders::customer.payment_success',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@paymentSuccessCustomer',
        ],
    ];

    protected $bindings = [
        OrdersCcLogsEntryModel::class => CcLogModel::class,
        OrdersRefundRequestEntryModel::class => RefundRequestModel::class,
        OrdersOrderpaymentsEntryModel::class => OrderpaymentModel::class,
        OrdersOrderdetailEntryModel::class => OrderdetailModel::class,
        OrdersOrderEntryModel::class => OrderModel::class,
        OrdersPaymentNameEntryModel::class => PaymentNameModel::class,
        OrdersPaymentReasonEntryModel::class => PaymentReasonModel::class
    ];

    protected $singletons = [
        CcLogRepositoryInterface::class => CcLogRepository::class,
        RefundRequestRepositoryInterface::class => RefundRequestRepository::class,
        OrderpaymentRepositoryInterface::class => OrderpaymentRepository::class,
        OrderdetailRepositoryInterface::class => OrderdetailRepository::class,
        OrderRepositoryInterface::class => OrderRepository::class,
        PaymentNameRepositoryInterface::class => PaymentNameRepository::class,
        PaymentReasonRepositoryInterface::class => PaymentReasonRepository::class
    ];
}
