<?php namespace Visiosoft\OrdersModule\Listener;

use Monolog\Handler\StreamHandler;
use Monolog\Logger;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\PaymentModule\Payment\Commands\Invoice;
use Visiosoft\ProfileModule\Adress\AdressModel;

class CreateInvoiceListener
{
    public function handle(OrderApproved $event)
    {
        try {
            $invoice = new Invoice();

            $order = $event->getOrder();
            $detail = $event->getOrderDetail();

            $params['id'] = $order->id;
            $params['amount'] = $order->total;
            $params['quantity'] = $detail->piece ?? '1';
            $params['tax_percent'] = $order->tax ?? '0';
            $params['user_id'] = $order->user->id;
            $params['display_name'] = $order->user->display_name ?? 'Muhtelif Alıcı';
            $params['phone'] = $order->user->phone ?? '+905555555555';
            $params['city'] = $order->user->city ?? 'No City';
            $params['email'] = $order->user->email ?? setting_value("streams::email");
            $address = AdressModel::query()->where('user_id', $params['user_id'])->first();
            $params['address'] = $address->adress_content ?? '';
            $params['zip_code'] = $address->zip_code ?? '34000';
            $params['country'] = $address->country->name ?? 'Türkiye';
            $params['tax_number'] = $address->tax_number ?? null;


            $invoice->createInvoiceWithParams($params['id'], $params['amount'], $params['quantity'], $params['tax_percent'],
            $params['user_id'], $params['display_name'], $params['phone'], $params['city'], $params['email'], $params['address'],
            $params['zip_code'], $params['country'], $params['tax_number']);
        } catch (\Exception $e) {
            $log = new Logger('create_invoice_listener');
            $log->pushHandler(new StreamHandler(storage_path('logs/create_invoice_listener.log')), Logger::ERROR);
            $log->error($e);
        }
    }
}
