<?php namespace Visiosoft\OrdersModule\Order\Table;

class OrderTableFilters
{
    public function handle(OrderTableBuilder $builder)
    {
        $type_filter_options = [
            'adv' => 'visiosoft.module.orders::field.adv.name',
            'ads-configuration' => 'visiosoft.module.orders::field.ads-configuration.name',
        ];


        //For Dopings
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.dopings')) ?
                ['doping' => 'visiosoft.module.orders::field.doping.name'] : []);

        //For Balances
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.balances')) ?
                ['balance' => 'visiosoft.module.orders::field.balance.name'] : []);

        //For Packages
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.packages')) ?
                ['package' => 'visiosoft.module.orders::field.package.name'] : []);

        //For Site
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.site')) ?
                ['site' => 'visiosoft.module.orders::field.site.name', 'bundle' => 'visiosoft.module.orders::field.bundle.name'] : []);

        //For Subscriptions
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.subscriptions')) ?
                ['Subscription' => 'visiosoft.module.orders::field.Subscription.name'] : []);

        //For Store
        $type_filter_options = array_merge($type_filter_options,
            (is_module_installed('visiosoft.module.store')) ?
                ['store' => 'visiosoft.module.orders::field.store.name', 'store-doping' => 'visiosoft.module.orders::field.store-doping.name'] : []);

        $filters = [
            'user',
            'status' => [
                'filter' => 'select',
                'placeholder' => trans('visiosoft.module.orders::field.status.name'),
                'options' => [
                    'approved' => trans('visiosoft.module.orders::field.approved'),
                    'rejected' => trans('visiosoft.module.orders::field.rejected'),
                    'pending' => trans('visiosoft.module.orders::field.pending'),
                ]
            ],
            'type' => [
                'filter' => 'select',
                'options' => $type_filter_options,
            ],
        ];

        $builder->setFilters($filters);
    }
}
