<?php namespace Visiosoft\OrdersModule\Order\Table;

class OrderTableColumns
{
    public function handle(OrderTableBuilder $builder)
    {
        $builder->setColumns([
	        'id' => 'entry.id',
	        'user' => [
	        	'wrapper' => '<a href="/admin/users/edit/{value.id}">{value.name}</a>',
		        'value' => [
		        	'name' => 'entry.user.name()',
			        'id' => 'entry.user.id'
		        ],
	        ],
	        'pay_type',
	        'total' => [
		        'value' => 'entry.total.currency',
	        ],
	        'order_at',
	        'status' => [
		        'value' =>trans('visiosoft.module.orders::field.{entry.status}')
	        ]
        ]);
    }
}
