<?php namespace Visiosoft\OrdersModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\ResourceController;
use Illuminate\Support\Facades\Auth;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\RefundRequest\Contract\RefundRequestRepositoryInterface;
use Visiosoft\OrdersModule\RefundRequest\Events\CreatedRefundRequest;

class RefundRequestController extends ResourceController
{
    protected $repository;
    protected $orderdetailRepository;

    public function __construct(RefundRequestRepositoryInterface $repository, OrderdetailRepositoryInterface $orderdetailRepository)
    {
        $this->repository = $repository;
        $this->orderdetailRepository = $orderdetailRepository;
        parent::__construct();
    }

    public function refundRequest()
    {
        $response = [
            'status' => true,
            'message' => ''
        ];

        //Check Require Fields
        if (!$this->request->has(['refund_request_message', 'refund_request_type', 'detail_id'])) {
            $response['message'] = trans('visiosoft.module.orders::message.required_fields_error');
            $response['status'] = false;
        }

        //Check Detail Record
        if ($response['status'] and !$detail = $this->orderdetailRepository->find($this->request->detail_id) or $detail->created_by_id != Auth::id()) {
            $response['message'] = trans('visiosoft.module.orders::message.order_records_could_not_be_accessed');
            $response['status'] = false;
        }

        if ($response['status']) {
            $refund = $this->repository->createRefundRequest($detail->getId(),
                $this->request->refund_request_type . " | " .
                $this->request->refund_request_message);

            event(new CreatedRefundRequest($refund));

            $this->messages->success(trans('visiosoft.module.orders::message.created_refund_request', ['id' => $refund->getId()]));
        }

        return response()->json($response);
    }
}
