<?php namespace Visiosoft\OrdersModule\Orderdetail;

use Illuminate\Support\Facades\Auth;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\OptionConfiguration\Contract\OptionConfigurationRepositoryInterface;
use Visiosoft\DopingsModule\Doping\DopingModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailInterface;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderdetailEntryModel;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\PackagesModule\User\UserModel;
use Visiosoft\StoreModule\Store\Contract\StoreRepositoryInterface;

class OrderdetailModel extends OrdersOrderdetailEntryModel implements OrderdetailInterface
{
    public function create_datail(array $attr)
    {
        return $this->create($attr)->getId();
    }

    public function getDetail($id)
    {
        return $this->where('order_id', $id)->get();
    }

    public function getOrder($id)
    {
        return $this->find($id);
    }

    public function listMySales()
    {
        $advModel = new AdvModel();

        $my_ads = $advModel->getAdv(null, false)
            ->where('advs_advs.created_by_id', Auth::id())
            ->get()
            ->pluck('id')
            ->all();

	    $query = $this->newQuery()->where(function ($q) use ($my_ads) {
		    return $q->whereNull('seller_id')->whereIn('item_id', $my_ads);
	    })->orWhere('seller_id', Auth::id())
		    ->leftJoin('orders_order', 'orders_orderdetail.order_id', 'orders_order.id');
	    if (setting_value('visiosoft.module.orders::hide_unpaid_for_iyzico')) {
		    $query = $query->where(function ($query) {
			    $query->where('orders_order.pay_type', '!=', 'iyzico')
				    ->orWhere('orders_order.status', '!=', 'pending');
		    });
	    }

        return $query->select('orders_orderdetail.*')->orderByDesc('id')->get();
    }

    public function setStatus($id, $type)
    {
        $this->find($id)->update(['status' => $type]);
    }

    public function getDetailName($showStatus = true)
    {
        $advRepository = app(AdvRepositoryInterface::class);
        $orderdetailRepository = app(OrderdetailRepositoryInterface::class);
        $optionConfigurationRepository = app(OptionConfigurationRepositoryInterface::class);

        $isActivePackages = $advRepository->getModel()->is_enabled('packages');
        $isDopingsActive = $advRepository->getModel()->is_enabled('dopings');
        if ($this->item_type == 'adv') {
            $adv = $advRepository->getListItemAdv($this->item_id);
            $status = $orderdetailRepository->getStatus($this->id);
            return '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->id . '</a>' .
                ($showStatus ? ' | ' . $status : '') .
                ' | ' . '<a href="' . route("adv_detail", [$adv->id]) . '">' . $adv->name . '</a>' .
                ' | ' . $this->notes .
                ' | ' . $this->tracking_number;
        } else if ($this->item_type == 'package') {
            if ($isActivePackages) {
                $user_package_model = new UserModel();
                $packageModel = new PackageModel();

                if ($user_entry = $user_package_model->find($this->item_id)
                    and $package = $packageModel->find($user_entry->package_id)) {
                    return $package->name;
                }
            }
        } else if ($this->item_type == 'ads-configuration') {
            if ($configuration = $optionConfigurationRepository->find($this->item_id)) {
                return $configuration->getName();
            }
        } else if ($this->item_type == 'doping') {
            if ($isDopingsActive) {
                $DopingModel = new DopingModel();
                $doping = $DopingModel->newQuery()->find($this->item_id);
                return $doping->name;
            }

        } else if ($this->item_type == 'balance') {
            return trans('visiosoft.module.orders::field.balance.name');
        } else if ($this->item_type == 'Subscription') {
            return "Plan Purchase";
        } else if ($this->item_type == 'site') {
            return $this->notes;
        }
    }

    public function getTypeTitle()
    {
        return trans('visiosoft.module.orders::field.' . $this->item_type . '.name');
    }

    public function getType()
    {
        return $this->item_type;
    }

    public function delivered()
    {
        $this->update([
            'status' => 'paid_buyer'
        ]);
    }
}
