<?php namespace Visiosoft\OrdersModule\Order;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;

class OrderRepository extends EntryRepository implements OrderRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OrderModel
     */
    protected $model;
    protected $orderdetail;

    /**
     * Create a new OrderRepository instance.
     *
     * @param OrderModel $model
     */
    public function __construct(OrderModel $model, OrderdetailRepositoryInterface $orderdetail)
    {
        $this->model = $model;
        $this->orderdetail = $orderdetail;
    }

    public function approveOrder($orderId)
    {
        $this->model->status('approved', $orderId);
    }

    public function rejectOrder($orderId)
    {
        $this->find($orderId)->update(['status' => 'rejected']);
    }
}
