<?php namespace Visiosoft\OrdersModule\Order\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\OrdersModule\Order\Table\Actions\Approve;
use Visiosoft\OrdersModule\Order\Table\Actions\Reject;

class OrderTableBuilder extends TableBuilder
{
    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'approve' => [
            'handler' => Approve::class,
            'class' => 'btn btn-success'
        ],
        'reject' => [
            'handler' => Reject::class,
            'class' => 'btn btn-danger'
        ],
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
        'order_by' => [
            'id' => 'DESC',
        ],
    ];

    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.advs::js/admin/filter-user.js',
        ],
        'styles.css' => [
            'visiosoft.module.advs::css/admin/filter-user.css',
        ],
    ];
}
