<?php namespace Visiosoft\OrdersModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;
use Visiosoft\OrdersModule\Seed\PaymentNameSeeder;

class OrdersModuleSeeder extends Seeder
{
    use DispatchesJobs;
    public function run()
    {
        // Payment Name Seeder
        $this->call(PaymentNameSeeder::class);

        if (is_module_installed('visiosoft.module.notifications')) {
            $templates = [
                [
                    'en' => [
                        'message' => '
                            <h1>Your Product Return Request Has Been Received</h1>
                            <p>Your return request has been received for your <a href="{ad_url}">{ad_name}</a> product.</p>
                            <p><a href="{order_url}">Show Order</a></p>
                        ',
                        'name' => 'Created Refund Notification for User',
                        'greeting' => 'Hello',
                        'subject' => 'Your Product Return Request Has Been Received'
                    ],
                    'slug' => 'created_refund_notification_for_user',
                    'stream' => 'orders',
                ],
                [
                    'en' => [
                        'message' => '
                            <h1>Your Product Return Request Has Been Received</h1>
                            <p>Your return request has been received for your <a href="{ad_url}">{ad_name}</a> product.</p>
                            <p><a href="{seller_order_url}">Show Order</a></p>
                        ',
                        'name' => 'Created Refund Notification for Seller',
                        'greeting' => 'Hello',
                        'subject' => 'Your Product Return Request Has Been Received!'
                    ],
                    'slug' => 'created_refund_notification_for_seller',
                    'stream' => 'orders',
                ],
                [
                    'en' => [
                        'message' => '
                            <h1>Return Request for {ad_name}</h1>
                            <p>A return request has been created for the <a href="{ad_url}">{ad_name}</a>.</p>
                            <p><a href="{admin_refund_url}">Show Refund Request</a></p>
                        ',
                        'name' => 'Created Refund Notification for Admin',
                        'greeting' => 'Hello',
                        'subject' => 'Return Request for {ad_name}'
                    ],
                    'slug' => 'created_refund_notification_for_admin',
                    'stream' => 'orders',
                ],
                [
                    'en' => [
                        'message' => '
                            <h1>Your Product Return status has been concluded!</h1>
                            <p>Your return request for your <a href="{ad_url}">{ad_name}</a> product has been concluded.</p>
                            <p>{refund_message}</p>
                            <p><a href="{order_url}">Show Order</a></p>
                        ',
                        'name' => 'Refund Status Changed Notification for User',
                        'greeting' => 'Hello',
                        'subject' => 'Your Product Return status has been concluded!'
                    ],
                    'slug' => 'refund_status_changed_for_user',
                    'stream' => 'orders',
                ],
                [
                    'en' => [
                        'message' => '
                            <h1>The product return status has been changed.</h1>
                            <p>The return status for the <a href="{ad_url}">{ad_name}</a> product has been changed.</p>
                            <p>{refund_message}</p>
                            <p><a href="{seller_order_url}">Show Order</a></p>
                        ',
                        'name' => 'Refund Status Changed Notification for Seller',
                        'greeting' => 'Hello',
                        'subject' => 'The product return status has been changed!'
                    ],
                    'slug' => 'refund_status_changed_for_seller',
                    'stream' => 'orders',
                ],
                [
                    'en' => [
                        'message' => '
                            <h1>The product return status has been changed.</h1>
                            <p>The return status for the <a href="{ad_url}">{ad_name}</a> product has been changed.</p>
                            <p>{refund_message}</p>
                            <p><a href="{admin_refund_url}">Show Refund Request</a></p>
                        ',
                        'name' => 'Refund Status Changed Notification for Admin',
                        'greeting' => 'Hello',
                        'subject' => 'Changed Refund Request Status for {ad_name}'
                    ],
                    'slug' => 'refund_status_changed_for_admin',
                    'stream' => 'orders',
                ],
                [
                    'en' => [
                        'message' => '
                            <h1>Your {ad_name} product has been shipped.</h1>
                            <p>Tracking Number : <b>{tracking_number}</b></p>
                            <p>Transport Days : <b>{tracking_days}</b></p>
                            <p>Transport Detail URL : <a href="{tracking_detail_url}">View Transport Status</a></p>
                            <p><a href="{order_url}">Show Order</a></p>
                        ',
                        'name' => 'Added Tracking Number',
                        'greeting' => 'Hello',
                        'subject' => 'Your product has been shipped.'
                    ],
                    'slug' => 'added_tracking_number',
                    'stream' => 'orders',
                ],
                [
                    'en' => [
                        'message' => '<p class="text-center">#{order_id} Order Created!</p>
                                    <p><br></p>
                                    <p class="text-center">{items}</p>
                                    <p><br></p>
                                    <p class="text-center">Delivery Address: {delivery}</p>
                                    <p><br></p>
                                    <p class="text-center">Billing Address: {billing}</p>
                                    <p><br></p>
                                    <p class="text-center"><a href="{url}" target="_blank">Show Order Detail</a></p>
                                    <p><br></p>',
                        'name' => 'Order Created!',
                        'greeting' => 'Hi',
                        'subject' => '#{order_id} Order Created!'
                    ],
                    'stream' => 'orders',
                    'slug' => 'order_created'
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Your payment has been processed</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image es-p30b" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_0c26836b611cce1fb928d2ae6a88717b/images/71891596543538047.png" alt style="display: block;"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p25b">
                                                                 <h1>Order Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="20"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p><span style="color: #555554; font-size: 40px;">1,609‬ $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="71"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                        'name' => 'Payment Success',
                        'subject' => 'Payment Success | Openclassify.com'
                    ],
                    'stream' => 'orders',
                    'slug' => Str::slug('Payment Success', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Your payment has been processed</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p15b">
                                                                 <h1>Payment Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="24"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p><span style="color: #555554; font-size: 40px;">1,609‬ $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-button es-p40t es-p10b es-p10r es-p10l"><span class="es-button-border" style="border-width: 0px; border-color: #2cb543; background: #ffb600; border-radius: 4px;"><a href class="es-button" target="_blank" style="background: #ffb600; border-color: #ffb600; border-radius: 4px; font-size: 16px;">PAY NOW</a></span></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="71"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                        'name' => 'Payment Reminder',
                        'subject' => 'Payment Reminder | Openclassify.com'
                    ],
                    'stream' => 'orders',
                    'slug' => Str::slug('Payment Reminder', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Payment pending email</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image es-p30b" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_bd08215a87ce65fea1d1e7899063669a/images/86711596544653061.png" alt style="display: block;"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p25b">
                                                                 <h1>Order Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <!--[if mso]><table width="560" cellpadding="0" cellspacing="0"><tr><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-left" align="left">
                                             <tbody>
                                             <tr>
                                                 <td width="270" class="esd-container-frame es-m-p20b" align="center">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="right" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">Algoia Search Integration</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td><td width="20"></td><td width="270" valign="top"><![endif]-->
                                         <table cellpadding="0" cellspacing="0" class="es-right" align="right">
                                             <tbody>
                                             <tr>
                                                 <td width="270" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="left" class="esd-block-text es-m-txt-c">
                                                                 <p><span style="color:#788995;">859.00 $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                         <!--[if mso]></td></tr></table><![endif]-->
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="20"></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p><span style="color: #555554; font-size: 40px;">1,609‬ $</span><span data-cke-bookmark="1" style="display: none;">&nbsp;</span></p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="71"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                        'name' => 'Payment Pending',
                        'subject' => 'Payment Pending | Openclassify.com'
                    ],
                    'stream' => 'orders',
                    'slug' => Str::slug('Payment Pending', '_')
                ],
                [
                    'en' => [
                        'message' => '<tr>
                                     <td class="esd-structure es-p20t es-p20b es-p20r es-p20l" align="left">
                                         <table width="100%" cellspacing="0" cellpadding="0">
                                             <tbody>
                                             <tr>
                                                 <td class="esd-container-frame" width="560" valign="top" align="center">
                                                     <table width="100%" cellspacing="0" cellpadding="0">
                                                         <tbody>
                                                         <tr>
                                                             <td class="esd-block-text es-m-txt-l es-p15t es-p15b es-m-p15t es-m-p0b es-m-p0r es-m-p0l" align="left">
                                                                 <h2><strong>Your payment failed</strong></h2>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Hi user,</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p15t" align="left">
                                                                 <p style="color: #707070;">Lorem Ipsum is simply dummy text of the printing and industry.&nbsp;<br>Has been worked the industry\'s standard dummy text ever since the 1500s when.</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td class="esd-block-text es-p20t" align="left">
                                                                 <p style="color: #707070;">Lorem Visiosoft<br>Printing and typesetting team</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-image es-p30b" style="font-size: 0px;"><a target="_blank"><img src="https://hnmyrc.stripocdn.email/content/guids/CABINET_94690ce1fab16e20c24e1c60d386e3ae/images/80711596544869547.png" alt style="display: block;"></a></td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-text es-p20b">
                                                                 <h1>Order Details<span data-cke-bookmark="1" style="display: none;">&nbsp;</span></h1>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" align="center" class="esd-container-frame">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-text">
                                                                 <p style="color: #d11406; font-size: 24px;">Faulty Card</p>
                                                             </td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>
                                 <tr>
                                     <td class="esd-structure es-p20t es-p20r es-p20l" align="left">
                                         <table cellpadding="0" cellspacing="0" width="100%">
                                             <tbody>
                                             <tr>
                                                 <td width="560" class="esd-container-frame" align="center" valign="top">
                                                     <table cellpadding="0" cellspacing="0" width="100%">
                                                         <tbody>
                                                         <tr>
                                                             <td align="center" class="esd-block-text"><span style="color: #555554; font-size: 40px;"></span>
                                                                 <p style="color: #989898;">please try again</p>
                                                                 <p style="display: none;">&nbsp;</p>
                                                             </td>
                                                         </tr>
                                                         <tr>
                                                             <td align="center" class="esd-block-spacer" height="60"></td>
                                                         </tr>
                                                         </tbody>
                                                     </table>
                                                 </td>
                                             </tr>
                                             </tbody>
                                         </table>
                                     </td>
                                 </tr>',
                        'name' => 'Payment Failed',
                        'subject' => 'Payment Failed | Openclassify.com'
                    ],
                    'stream' => 'orders',
                    'slug' => Str::slug('Payment Failed', '_')
                ]
            ];

            foreach ($templates as $template) {
                $this->dispatchNow(new CreateTemplate($template));
            }
        }
    }
}