<?php namespace Visiosoft\OrdersModule\Order;

use Anomaly\UsersModule\User\UserModel;
use Illuminate\Support\Facades\Auth;
use Rinvex\Subscriptions\Models\PlanSubscription;
use Rinvex\Subscriptions\Services\Period;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\BalancesModule\Balance\BalanceModel;
use Visiosoft\DopingsModule\Http\Controller\Admin\DopingsController;
use Visiosoft\LocationModule\City\CityModel;
use Visiosoft\LocationModule\Country\CountryModel;
use Visiosoft\LocationModule\District\DistrictModel;
use Visiosoft\OrdersModule\Events\StoreOrderApproved;
use Visiosoft\OrdersModule\Order\Contract\OrderInterface;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderEntryModel;
use Visiosoft\OrdersModule\Order\Events\OrderApproved;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\PackagesModule\Package\PackageModel;
use Visiosoft\ProfileModule\Adress\AdressModel;
use Visiosoft\SiteModule\Addon\AddonModel;
use Visiosoft\SiteModule\Site\Event\AddAddonSite;
use Visiosoft\SubscriptionsModule\Subscription\SubscriptionModel;
use Visiosoft\SubscriptionsModule\SubscriptionRenewRequest\SubscriptionRenewRequestModel;

class OrderModel extends OrdersOrderEntryModel implements OrderInterface
{
    public function create_orders(array $attr)
    {
        $bill = AdressModel::query()->find($attr['bill_address']);
        $bill_district = DistrictModel::query()->find($bill->district) ? DistrictModel::query()->find($bill->district)->name : '';
        $bill_city = CityModel::query()->find($bill->city)->name;
        $bill_country = CountryModel::query()->find($bill->country)[0]->name;

        $orderBill = '<li class="list-group-item"><b>' . $bill->adress_first_name . ' ' . $bill->adress_last_name . '</b></li>'
            . '<li class="list-group-item">' . $bill->adress_content . '</li>'
            . '<li class="list-group-item">' . $bill_district . ' / ' . $bill_city . ' / ' . $bill_country . '</li>'
            . '<li class="list-group-item">' . $bill->adress_gsm_phone . '</li>';

        if ($bill->is_company) {
            $orderBill .= '<li class="list-group-item">' . trans('visiosoft.module.orders::field.company_name') . ': ' . $bill->company . '</li>';
            $orderBill .= '<li class="list-group-item">' . trans('visiosoft.module.orders::field.tax_office') . ': ' . $bill->tax_office . '</li>';
            $orderBill .= '<li class="list-group-item">' . trans('visiosoft.module.orders::field.tax_number') . ': ' . $bill->tax_number . '</li>';
        }

        if ($attr['delivery_address']) {
            $delivery = AdressModel::query()->find($attr['delivery_address']);
            $delivery_district = ($district = DistrictModel::query()->find($delivery->district)) ? $district->name : '';
            $delivery_city = CityModel::query()->find($delivery->city)->name;
            $delivery_country = CountryModel::query()->find($delivery->country)[0]->name;

            $orderDelivery = '<li class="list-group-item"><b>' . $delivery->adress_first_name . ' ' . $delivery->adress_last_name . '</b></li>'
                . '<li class="list-group-item">' . $delivery->adress_content . '</li>'
                . '<li class="list-group-item">' . $delivery_district . ' / ' . $delivery_city . ' / ' . $delivery_country . '</li>'
                . '<li class="list-group-item">' . $delivery->adress_gsm_phone . '</li>';

            if ($delivery->is_company) {
                $orderDelivery .= '<li class="list-group-item">' . trans('visiosoft.module.orders::field.company_name') . ': ' . $delivery->company . '</li>';
                $orderDelivery .= '<li class="list-group-item">' . trans('visiosoft.module.orders::field.tax_office') . ': ' . $delivery->tax_office . '</li>';
                $orderDelivery .= '<li class="list-group-item">' . trans('visiosoft.module.orders::field.tax_number') . ': ' . $delivery->tax_number . '</li>';
            }
        } else {
            $orderDelivery = $orderBill;
        }

        return $this->create([
            'user' => $attr['user'],
            'bill_address' => $attr['bill_address'],
            'delivery_address' => $attr['delivery_address'],
            'pay_type' => $attr['pay_type'],
            'total' => $attr['total'],
            'type' => $attr['type'],
            'subtotal' => $attr['subtotal'],
            'shipping' => $attr['shipping'],
            'tax' => $attr['tax'],
            'currency' => $attr['currency'],
            'status' => $attr['status'],
            'order_at' => $attr['order_at'],
            'bill_address_content' => $orderBill,
            'delivery_address_content' => $orderDelivery,
        ])->getId();
    }

    public function orders_total($items)
    {
        $total = 0;
        foreach ($items as $item) {
            $total += $item->total;
        }
        return $total;
    }

    public function setStatus($status, $id)
    {
        $orderDetail_model = new OrderdetailModel();
        $order_detail = $orderDetail_model->getDetail($id);

        foreach ($order_detail as $item) {

            if ($status == 'approved') {

                $orderDetail_model->getOrder($item->id)->update(['status' => 'awaiting_tracking_number']);

                if ($item->item_type == 'store' and is_module_installed('visiosoft.module.store')) {
                    event(new StoreOrderApproved($item));
                } else if ($item->item_type == 'doping' and is_module_installed('visiosoft.module.dopings')) {

                    $doping_controller = app(DopingsController::class);
                    $doping_controller->approve($item->item_id);

                } else if ($item->item_type == 'package' and is_module_installed('visiosoft.module.packages')) {
                    $package_model = new \Visiosoft\PackagesModule\User\UserModel();
                    if ($userForPackage = $package_model->newQuery()->find($item->item_id) and !$userForPackage->isApproved()) {
                        $packageModel = new PackageModel();
                        $packageModel->approvedStatus($userForPackage->id);
                    }

                } else if ($item->item_type == 'site' and is_module_installed('visiosoft.module.site')) {

                    $addonModel = new AddonModel();
                    $addon = $addonModel->newQuery()->find($item->item_id);
                    if ($addon) {
                        event(new AddAddonSite($addon->subdomain, $addon->addon));
                        $addon->update([
                            'payment' => true,
                            'installed' => 'pending'
                        ]);
                    }
                } else if ($item->item_type == 'balance' and is_module_installed('visiosoft.module.balances')) {

                    $balance_model = new BalanceModel();
                    $balance_model->approve($item->item_id);

                } else if ($item->item_type == 'Subscription' and is_module_installed('visiosoft.module.subscriptions')) {

                    $subscriptionRenew_model = new SubscriptionRenewRequestModel();

                    $is_renew_or_upgrade = $subscriptionRenew_model
                        ->whereRaw("( new_plan_id = " . $item->item_id . " OR old_plan_id = " . $item->item_id . " )")
                        ->where('created_by_id', $item->created_by_id)
                        ->where('status', '!=', 'success')
                        ->where('status', '!=', 'canceled')
                        ->orderBy('id', 'desc')
                        ->first();
                    if ($is_renew_or_upgrade) {
                        $subscription_model = new PlanSubscription();
                        $user = new \Visiosoft\SubscriptionsModule\User\UserModel();
                        $subscriptionDetails = $subscription_model->find($is_renew_or_upgrade->subscription_id);
                        $user = $user->find($item->created_by_id);

                        if ($is_renew_or_upgrade->new_plan_id == 0) {
                            //Subscription Extend
                            $subscriptionDetails = $subscription_model->find($is_renew_or_upgrade->subscription_id);
                            $subscription = $user->subscription($subscriptionDetails->slug);


                            $old_day = (strtotime($subscription->ends_at) - strtotime($subscription->starts_at)) / 86400;
                            $old_day = round($old_day, 0);

                            $expiresDate = strtotime('+' . $subscription->plan->invoice_period . ' ' . $subscription->plan->invoice_interval, strtotime(now()));
                            $expiresSumOldDate = strtotime('+' . $old_day . ' days', $expiresDate);

                            $expired_day = ($expiresSumOldDate - strtotime(now())) / 86400;
                            $expired_day = round($expired_day, 0);

                            $subscription = $subscription_model->find($subscription->id);

                            $period = new Period('day', $expired_day, '');

                            $subscription->starts_at = $period->getStartDate();
                            $subscription->ends_at = $period->getEndDate();
                            $subscription->canceled_at = null;

                            $subscription->save();

                        } else {
                            //Subscription Upgrade
                            $subscriptionDetails->update(['plan_id' => $is_renew_or_upgrade->new_plan_id]);
                            $user->subscription($subscriptionDetails->slug)->renew();
                        }
                        $is_renew_or_upgrade->update(['status' => 'success', 'order_id' => $id]);

                    } else {
                        //Buy new Subscription
                        $SubscriptionModel = new SubscriptionModel();
                        $SubscriptionModel->addPlanUser($item->item_id);
                    }
                } else if ($item->item_type == 'adv') {
                    $ad_model = app(AdvModel::class);
                    $ad_model->updateStock($item->item_id, $item->piece);
                }


            }
        }

        if($order = $this->newQuery()->find($id)){
            //Event OrderApproved
            event(new OrderApproved($order, $order_detail));

            return $order->update(['status' => $status]);
        }
    }

    public function getOrder($id)
    {
        return $this->find($id);
    }

    public function findMyOrder($id)
    {
        return $this->where('user_id', Auth::id())
            ->where('id', $id)->first();
    }

    public function getOrderUser($uid)
    {
        return UserModel::query()->find($uid);
    }

    public function getLastOrderByUser()
    {
        return OrderModel::query()
            ->where('user_id', Auth::id())
            ->orderByDesc('id')
            ->first();
    }

    public function listMyOrders($userID = null)
    {
        $userID = $userID ?: \auth()->id();

        $query = OrderModel::query()
            ->where('user_id', $userID);

        if (setting_value('visiosoft.module.orders::hide_unpaid_for_iyzico')) {
            $query = $query->where(function ($query) {
                $query->where('pay_type', '!=', 'iyzico')
                    ->orWhere('status', '!=', 'pending');
            });
        }

        return $query->orderByDesc('id')->paginate(setting_value('streams::per_page'));
    }

    public function details()
    {
        return $this->hasMany(OrderdetailModel::class, 'order_id');
    }
}
