<?php namespace Visiosoft\OrdersModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\OrdersModule\RefundRequest\Contract\RefundRequestRepositoryInterface;
use Visiosoft\OrdersModule\RefundRequest\RefundRequestRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersRefundRequestEntryModel;
use Visiosoft\OrdersModule\RefundRequest\RefundRequestModel;
use Anomaly\Streams\Platform\Model\Orders\OrdersPaymentNameEntryModel;
use Visiosoft\OrdersModule\Orderpayment\Contract\OrderpaymentRepositoryInterface;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderpaymentsEntryModel;
use Visiosoft\OrdersModule\Orderpayment\OrderpaymentModel;
use Visiosoft\OrdersModule\Orderdetail\Contract\OrderdetailRepositoryInterface;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderdetailEntryModel;
use Visiosoft\OrdersModule\Orderdetail\OrderdetailModel;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;
use Visiosoft\OrdersModule\Order\OrderRepository;
use Anomaly\Streams\Platform\Model\Orders\OrdersOrderEntryModel;
use Visiosoft\OrdersModule\Order\OrderModel;
use Visiosoft\OrdersModule\PaymentName\Contract\PaymentNameRepositoryInterface;
use Visiosoft\OrdersModule\PaymentName\PaymentNameModel;
use Visiosoft\OrdersModule\PaymentName\PaymentNameRepository;

class OrdersModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        OrdersModulePlugin::class
    ];

    protected $routes = [
        'admin/orders/refund_request' => 'Visiosoft\OrdersModule\Http\Controller\Admin\RefundRequestController@index',

        // OrderController
        'sale' => [
            'middleware' => 'auth',
            'as' => 'orders::sale',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@sale',
        ],
        'sale/detail/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_detail',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@saleDetail',
        ],
        'sale/report' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_report',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@reportSales',
        ],
        'sale/addTrackingNumber' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_addTrackingNumber',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@addTrackingNumber',
        ],
        'sale/setStatus/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::sale_setStatus',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@updateStatus'
        ],
        'purchase' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchase',
        ],
        'purchase/delivered/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase_delivered',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@orderDelivered',
        ],
        'purchase/not-delivered/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase_not_delivered',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@orderNotDelivered',
        ],
        'purchase/detail/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::purchase_detail',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchaseDetail',
        ],
        'purchase/cancel/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::cancel',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@purchaseCancel',
        ],

        'order/approve/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::approve',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@approve',
        ],

        'order/reject/{id}' => [
            'middleware' => 'auth',
            'as' => 'orders::reject',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@reject',
        ],

        // Admin OrderpaymentsController
        'admin/orders/orderpayments' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@index',
        'admin/orders/orderpayments/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@create',
        'admin/orders/orderpayments/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@edit',
        'admin/ordersPayment/approve/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderpaymentsController@approve',

        // Admin OrderdetailController
        'admin/orders/orderdetail' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@index',
        'admin/orders/orderdetail/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@create',
        'admin/orders/orderdetail/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@edit',
        'admin/orders/orderdetail/print/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderdetailController@print',

        // Admin OrderController
        'admin/orders' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@index',
        'admin/orders/create' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@create',
        'admin/orders/edit/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@edit',
        'admin/orders/approve/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@approve',
        'admin/orders/reject/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@reject',
        'admin/orders/delivered/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@delivered',
        'admin/orders/print/{id}' => 'Visiosoft\OrdersModule\Http\Controller\Admin\OrderController@print',

        // ApiController
        'api/orders/user-orders' => [
            'middleware' => 'auth',
            'as' => 'visiosoft.module.orders::api_orders_user_orders',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\ApiController@getUserOrders',
        ],
        'ajax/purchase/refund_request' => [
            'as' => 'visiosoft.module.orders::ajax.refund_request',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\RefundRequestController@refundRequest',
        ],


        //Customer
        'customer-order/detail' => [
            'as' => 'visiosoft.module.orders::customer.payment_success',
            'uses' => 'Visiosoft\OrdersModule\Http\Controller\OrderController@paymentSuccessCustomer',
        ],
    ];

    protected $bindings = [
        OrdersRefundRequestEntryModel::class => RefundRequestModel::class,
        OrdersOrderpaymentsEntryModel::class => OrderpaymentModel::class,
        OrdersOrderdetailEntryModel::class => OrderdetailModel::class,
        OrdersOrderEntryModel::class => OrderModel::class,
        OrdersPaymentNameEntryModel::class => PaymentNameModel::class
    ];

    protected $singletons = [
        RefundRequestRepositoryInterface::class => RefundRequestRepository::class,
        OrderpaymentRepositoryInterface::class => OrderpaymentRepository::class,
        OrderdetailRepositoryInterface::class => OrderdetailRepository::class,
        OrderRepositoryInterface::class => OrderRepository::class,
        PaymentNameRepositoryInterface::class => PaymentNameRepository::class
    ];
}
