<?php namespace Visiosoft\OrdersModule\Events;

use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class OrderCreated
{

    public $order_id;

    public function __construct($order_id)
    {
        $this->order_id = $order_id;
    }

    public function getOrder()
    {
        $order_repository = app(OrderRepositoryInterface::class);

        return $order_repository->find($this->order_id);
    }

    public function getOrderDetail()
    {
        return $this->getOrder()->details();
    }
}
