function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}

$('.try-demo-openclassify').on('click', function () {
    $('#freetrialForm').modal('toggle');
});

$("#tryOpenclassify").submit(function (e) {

    e.preventDefault();
    var email = $(this).find('input[name="email"]').val();
    var name = $(this).find('input[name="name_surname"]').val();
    var storename = $("input[name='storename']").val();
    storename = storename.replace(/[^a-zA-Z ]/g, "").replace(/ /g, '');

    /*** Validation Email */
    if (validateEmail(email)) {
        $('#freetrialForm').modal('hide');

        var passthrough = {
            'name_surname': name,
            "email": email,
            'storename': storename
        }

        crud(passthrough, '/ajax/registerUser', 'POST', function (callback) {
            if (callback.status == "success") {
                success_register_msg = callback.message;
                /*** Open Payment */
                openPayment(email, passthrough)
            } else {
                /*** Show Error Modal */
                errorModal(callback.message)
            }
            $("#tryOpenclassify").trigger("reset");
        })
    }
});

function errorModal(message) {
    var modal = $('#response-modal');
    modal.find('.responseIcon').html("<i class='fa fa-times-circle text-danger'></i>");
    modal.find('.responseMessage').html(message);
    modal.modal('show');
}

function successModal(message) {
    var modal = $('#response-modal');
    modal.find('.responseIcon').html("<i class='fa fa-check text-success'></i>");
    modal.find('.responseMessage').html(message);
    modal.modal('show');
}

function openPayment(email, parameters) {
    Paddle.Checkout.open({
        product: pCode,
        passthrough: parameters,
        email: email,
        closeCallback: "checkoutClose",
        successCallback: "checkoutComplete",
    });
}

function checkoutComplete(data) {
    successModal(success_register_msg.toLowerCase())
}

function checkoutClose() {
    successModal(success_register_msg.toLowerCase())
}

$('.tryFormOnlyEmail').on('submit', function (e) {
    e.preventDefault();
    $('#freetrialForm').find('input[type="email"]').val($('.tryFormOnlyEmail').find('.email').val());
    $('#freetrialForm').modal('toggle');
});

var success_register_msg = "";