$("#search_btn").on('click',() => {
    $(".listing-search").removeClass('d-none');
    $("#mobileListNav").attr('style','display: none !important');
});

$(".close-search-nav").on('click',() => {
    $(".listing-search").addClass('d-none');
    $("#mobileListNav").attr('style','display: flex !important')
})

$("#oc_filter_modal_btn").on('click', () => {
    $("#listingContainer").addClass('d-none');
    $("#listingFilterMobile").removeClass('d-none');
});

$(".mobile-list-filter-close").on('click', () => {
    $("#listingContainer").removeClass('d-none');
    $("#listingFilterMobile").addClass('d-none');
});

function getURLParameters(url) {
    const params = new URLSearchParams(url.split('?')[1]);
    const result = {};
    for (const [key, value] of params.entries()) {
        const arrayKey = key.replace(/\[\]$/, '');
        if (key !== arrayKey) {
            result[arrayKey] = result[arrayKey] || [];
            result[arrayKey].push(value);
        } else {
            result[key] = value;
        }
    }
    return result;
}
$(window).on("load", () => {
    $('#category .main-category').on('click', (e) => {
        $(e.currentTarget).toggleClass('active').siblings('.sub-categories').slideToggle(250);
    })

    // If the "All products" button is clicked, disable all the checkboxes in the submenu, and if any of them are disabled, enable all disabled checkboxes.
    $('#category .all-subcat').on('click', (e) => {
        let subMenu = $(e.currentTarget).parents('.sub-categories');
        let disabledItems = subMenu.find('input:disabled');
        subMenu.find('.subcat').attr('disabled', disabledItems.length == 0);
    })

    const queryParams = getURLParameters(window.location.href);
    const cats = queryParams.cats || [];

    //Convert the cats from the queryParams into a single array.
    if(cats.length == 0 && queryParams['cats[0]']){
        let i = 0;
        while (queryParams['cats['+i+']']) {
            cats.push(queryParams['cats['+i+']']);
            i++;
        }
    }

    cats.forEach(cat => {

        let parent_category = $('#' + cat).parents('.category')

        // If all categories button are selected, select all subcategories.
        // If all but one of the checkboxes are checked in the subcategory list, select all subcategories.
        if ($('#' + cat).hasClass('all-subcat')  ){
            parent_category.find('.sub-categories .subcat').attr('disabled', true);
        }

        $('#' + cat).prop('checked',true);

        // If the active class of the parent category of the categories in the URL is not present, add the active class and expand the subcategories list.
        if(!parent_category.find('.main-category').hasClass('active')){
            parent_category.find('.main-category').addClass('active').siblings('.sub-categories').slideToggle(250);
        }


    })
})