$(document).ready(function () {
    $('.customer-logos').slick({
        slidesToShow: 5,
        slidesToScroll: 1,
        autoplay: true,
        centerMode: true,
        autoplaySpeed: 1500,
        arrows: false,
        dots: false,
        pauseOnHover: false,
        responsive: [{
            breakpoint: 1200,
            settings: {
                slidesToShow: 4
            }
        }, {
            breakpoint: 992,
            settings: {
                arrows: false,
                centerMode: true,
                centerPadding: '40px',
                slidesToShow: 3
            }
        }, {
            breakpoint: 768,
            settings: {
                arrows: false,
                centerMode: true,
                centerPadding: '40px',
                slidesToShow: 2
            }
        }]
    });

    $('.popup-youtube').magnificPopup({
        type: 'iframe',
        mainClass: 'mfp-fade',
        removalDelay: 160,
        preloader: false,
        fixedContentPos: true
    });

    // show/hide sub categories when clicked parent category for category filter area
    $('#category .main-category').on('click', (e) => {
        $(e.currentTarget).toggleClass('active').siblings('.sub-categories').slideToggle();
    })

    $('.price-area #priceHeading').on('click', (e) => {
        $(e.currentTarget).toggleClass('hide')
        $('.price-area #price').slideToggle();
    })

    // double range slider for left filter area in list page
    let lowerSlider = $('#lower'),
        upperSlider = $('#upper'),
        lowerVal, upperVal;

    $('#lower, #upper').on('input', () => {
        lowerVal = parseInt(lowerSlider.val());
        upperVal = parseInt(upperSlider.val());

        $('.max-label').html(upperVal)
        $('.min-label').html(lowerVal)


        if (lowerVal > upperVal + 4) {
            lowerSlider.val(upperVal - 4);
            if (lowerVal === lowerSlider.attr('min')) {
                upperSlider.value = 4;
            }
        }

        if (lowerVal > upperVal - 4) {
            upperSlider.val(upperSlider.attr('max'));
            if (upperVal === upperSlider.attr('max')) {
                lowerSlider.value = parseInt(upperSlider.attr('max')) - 4;
            }
        }
    })
});
