<?php namespace Visiosoft\OpenclassifyTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\OpenclassifyTheme\Form\RegisterOpenclassify;
use Visiosoft\OpenclassifyTheme\Form\RegisterTEST;
use Illuminate\Routing\Router;

class OpenclassifyThemeServiceProvider extends AddonServiceProvider
{

    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'sendMail' => [
            'uses' => 'Visiosoft\OpenclassifyTheme\Http\Controller\SendMailController@send',
            'verb' => 'POST'
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Anomaly\OpenclassifyTheme\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Anomaly\OpenclassifyTheme\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Anomaly\OpenclassifyTheme\Event\ExampleEvent::class => [
        //    Anomaly\OpenclassifyTheme\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Anomaly\OpenclassifyTheme\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        'streams::errors/404' => 'visiosoft.theme.base::errors/404',
        'streams::errors/403' => 'visiosoft.theme.base::errors/403',
        'anomaly.module.users::login' => 'visiosoft.theme.base::addons/anomaly/users-module/login',
        'anomaly.module.users::register' => 'visiosoft.theme.base::addons/anomaly/users-module/register',
        'anomaly.module.users::password/forgot' => 'visiosoft.theme.base::addons/anomaly/users-module/password/forgot',
        'anomaly.module.users::password/reset' => 'visiosoft.theme.base::addons/anomaly/users-module/password/reset',
        'streams::notifications/email' => 'visiosoft.theme.openclassify::notifications/email',
        'visiosoft.module.carts::login/oauth' => 'visiosoft.theme.openclassify::layouts/blank',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        $request = app('Illuminate\Http\Request');

        ($utm_source = $request->get('utm_source')) ? setcookie('utm_source', $utm_source) : null;
        ($utm_medium = $request->get('utm_medium')) ? setcookie('utm_medium', $utm_medium) : null;
        ($utm_campaign = $request->get('utm_campaign')) ? setcookie('utm_campaign', $utm_campaign) : null;
        ($utm_term = $request->get('utm_term')) ? setcookie('utm_term', $utm_term) : null;
        ($utm_content = $request->get('utm_content')) ? setcookie('utm_content', $utm_content) : null;
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
