<?php namespace Visiosoft\OpenclassifyTheme;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class OpenclassifyThemeSeeder extends Seeder
{

    protected $fieldRepository;
    protected $assignmentRepository;
    protected $streamRepository;

    public function __construct(FieldRepositoryInterface $fieldRepository,
                                AssignmentRepositoryInterface $assignmentRepository,
                                StreamRepositoryInterface $streamRepository)
    {
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customFieldRepository->newQuery()->firstOrCreate(
                ['slug' => str_slug(trans('theme::seeder.addon_preview_link'), '_')],
                ['name' => trans('theme::seeder.addon_preview_link'), 'type' => 'text']
            );
        }
    }
}

