var responseModal = $('#response-modal');
var responseModalIcon = responseModal.find('.icon-box');

function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}

$('.try-demo-openclassify').on('click', function () {
    $('#freetrialForm').modal('toggle');
});

$("#tryOpenclassify").submit(function (e) {
    console.log(1)

    e.preventDefault();
    var email = $(this).find('input[name="email"]').val();
    var name = $(this).find('input[name="name_surname"]').val();
    var subdomain = $("input[name='subdomain']").val();
    subdomain = subdomain.replace(/[^a-zA-Z ]/g, "").replace(/ /g, '');

    /*** Validation Email */
    if (validateEmail(email)) {
        $('#freetrialForm').modal('hide');

        var passthrough = {
            'name_surname': name,
            "email": email,
            'subdomain': subdomain
        }

        crud(passthrough, '/ajax/registerUser', 'POST', function (callback) {
            if (callback.status == "success") {
                /*** Open Payment */
                openPayment(email, passthrough)
            } else {
                /*** Show Error Modal */
                errorModal(callback.message)
            }
            $("#tryOpenclassify").trigger("reset");
        })
    }
});

function errorModal(message) {
    $('.message-response').html(message);
    responseModalIcon.html("<i class='fa fa-times' aria-hidden='true'></i>")
    responseModalIcon.attr('class', 'icon-box bg-errorr');
    responseModal.addClass('msg-error');
    responseModal.modal('toggle');
}

function successModal(message) {
    $('.message-response').html(message);
    responseModalIcon.html("<i class='fa fa-check' aria-hidden='true'></i>")
    responseModalIcon.attr('class', 'icon-box bg-success');
    responseModal.addClass('msg-success');
    responseModal.modal('toggle');
}

function openPayment(email, parameters) {
    Paddle.Checkout.open({
        product: pCode,
        passthrough: parameters,
        email: email,
        successCallback: "checkoutComplete",
    });
}

function checkoutComplete(data) {
    console.log(data)
    successModal(" Thank you for Registering!")
}

