function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}

$("#tryOpenclassify").submit(function (e) {
    e.preventDefault();
    var form = $(this);
    var responseModal = $('#response-modal');
    var responseModalIcon = responseModal.find('.icon-box');

    var name_surname = $( "input[name='name_surname']" ).val();
    var email = $( "input[name='email']" ).val();

    var subdomain = $( "input[name='subdomain']" ).val();
    subdomain = subdomain.replace(/[^a-zA-Z ]/g, "").replace(/ /g,'');

        $.ajax({
        type: 'POST',
        url: 'https://panel.openclassify.com/register/ajax',
        data: {
            'name_surname' :name_surname,
            'subdomain' : subdomain,
            'email' : email,
        },
        success: function (response) {
            $('#freetrialForm').modal('hide');
            if(response.status == "success")
            {
                $('.message-response').html(name_surname+" Thank you for Registering!");
                responseModalIcon.html("<i class='fa fa-check' aria-hidden='true'></i>")
                responseModalIcon.attr('class','icon-box bg-success');
            }else {
                $('.message-response').html(response.message);
                responseModalIcon.html("<i class='fa fa-exclamation' aria-hidden='true'></i>")
                responseModalIcon.attr('class','icon-box bg-dangerr');
            }
            $("#tryOpenclassify").trigger("reset");
            responseModal.addClass('msg-'+response.status);
            responseModal.modal('toggle');
        },
            error: function() {
                $('#freetrialForm').modal('hide');
                $('.message-response').html("Please contact the administrator!");
                responseModalIcon.html("<i class='fa fa-times' aria-hidden='true'></i>")
                responseModalIcon.attr('class','icon-box bg-errorr');
                responseModal.addClass('msg-error');
                responseModal.modal('toggle');
            }

    });
});

$(".footer-try-openclassify-form").submit(function (e) {
    e.preventDefault();
    if (!validateEmail($(this).find('input[type="email"]'))) {
        $('#freetrialForm').modal('toggle');
    }
});

$(".body-register-openclassify").submit(function (e) {
    e.preventDefault();
    if (!validateEmail($(this).find('input[type="email"]'))) {
        $('#freetrialForm').modal('toggle');
    }
});


$('.try-demo-openclassify').on('click', function () {
    $("input[id='plan_id']").val($(this).data('plan'));
    $('#freetrialForm').modal('toggle');
});

// $('#get-info-button').on('click', function () {
//     $('#liModal-21').modal('toggle');
// });
$('#main-text-input').on('change', function () {
    $("input[name='type']").val('Free Trial on Cloud');
    $('#heading').html('Free Trial on Cloud');
    $("#openclassifyMail").val($('#main-text-input').val());
});
$('.btn-orange').on('click',function(){
    $('#response-modal').modal('hide');
});