// Validate the email address in the form
function isValidEmail(form) {
    // If email is empty, show error message.
    // contains just one @
    var email = form.find("input[type='email']").val();
    if (!email || !email.length) {
        return false;
    } else if (email.indexOf("@") == -1) {
        return false;
    }
    return true;
}
$(document).ready(function () {
    var form = $('.header-subscribe-form')
    var form2 = $('.footer-subscribe-form')

    if (form.length > 0) {
        $('.header-subscribe-form input[type="submit"]').bind('click', function (event) {
            if (event) event.preventDefault()
            if (!isValidEmail(form)) {
                form.find("input[type='email']").css('border','1px solid red');
            } else {
                form.find("input[type='email']").css('border','none');
                register(form,'content')
            }
        })
    }
    if(form2.length > 0)
    {
        $('.footer-subscribe-form input[type="submit"]').bind('click', function (event) {
            if (event) event.preventDefault()
            if (!isValidEmail(form2)) {
                form2.find("input[type='email']").css('border-color','red');
            } else {
                form2.find("input[type='email']").css('border-color','#e5e5e5');
                register(form2,'footer')
            }
        })
    }
})


function register(form,field) {
    $.ajax({
        type: form.attr('method'),
        url: form.attr('action'),
        data: form.serialize(),
        cache: false,
        dataType: 'json',
        contentType: 'application/json; charset=utf-8',
        error: function (err) { alert('Could not connect to the registration server. Please try again later.') },
        success: function (data) {
            if (data.result === 'success') {
                // Success
                if(field == "footer")
                {
                    $('.footer-subscribe-form-field p').html("Thank you for subscribing. We have sent you a confirmation email.");
                    $('.footer-subscribe-form-field p').fadeIn().delay(5000).fadeOut();
                }
                if(field == "content")
                {
                    $('.content-subscribe-form-field p').html("Thank you for subscribing. We have sent you a confirmation email.");
                    $('.content-subscribe-form-field p').fadeIn().delay(5000).fadeOut();
                }
                // alert('Thank you for subscribing. We have sent you a confirmation email.');
            } else {
                if(field == "footer")
                {
                    $('.footer-subscribe-form-field p').html("This mail has been saved in the system ");
                    $('.footer-subscribe-form-field p').fadeIn().delay(5000).fadeOut();
                }
                if(field == "content")
                {
                    $('.content-subscribe-form-field p').html("This mail has been saved in the system ");
                    $('.content-subscribe-form-field p').fadeIn().delay(5000).fadeOut();
                }
            }
        }
    })
};