<?php namespace Visiosoft\OpenclassifyTheme;

use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class OpenclassifyThemeSeeder extends Seeder
{

    protected $fieldRepository;
    protected $assignmentRepository;
    protected $streamRepository;

    public function __construct(FieldRepositoryInterface $fieldRepository,
                                AssignmentRepositoryInterface $assignmentRepository,
                                StreamRepositoryInterface $streamRepository)
    {
        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        if (is_module_installed('visiosoft.module.customfields')) {
            $customFieldRepository = app(CustomFieldRepositoryInterface::class);
            $customFieldRepository->newQuery()->firstOrCreate(
                ['slug' => str_slug(trans('theme::seeder.addon_preview_link'), '_')],
                ['name' => trans('theme::seeder.addon_preview_link'), 'type' => 'text']
            );
        }

        $user_fields = [
            [
                'name' => 'utm_json',
                'slug' => 'utm_json',
                'type' => 'visiosoft.field_type.json',

            ],
            [
                'name' => 'browser_lang',
                'slug' => 'browser_lang',
                'type' => 'anomaly.field_type.text',

            ],
            [
                'name' => 'location_for_ip',
                'slug' => 'location_for_ip',
                'type' => 'anomaly.field_type.text',

            ]
        ];

        foreach ($user_fields as $user_field) {
            $stream = $this->streamRepository->findBySlugAndNamespace('users', 'users');

            if (!$field = $this->fieldRepository->findBySlugAndNamespace($user_field['slug'], 'users')) {
                $field = $this->fieldRepository->create([
                    'name' => $user_field['name'],
                    'namespace' => 'users',
                    'slug' => $user_field['slug'],
                    'type' => $user_field['type'],
                    'locked' => 0
                ]);
            }

            $assigment = $this->assignmentRepository->findByStreamAndField($stream, $field);
            if (!$assigment) {
                $this->assignmentRepository->create([
                    'stream_id' => $stream->getId(),
                    'field_id' => $field->getId()
                ]);
            }
        }

    }
}

