<?php

namespace Visiosoft\OnlyMembersExtension\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\URL;

class OnlyMembersMiddleware
{

    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {

        //Getting Uri's first segment characters.
        $segment = request()->segment(1);


        if ($segment !== 'admin' &&
            $segment !== 'login' &&
            $segment !== 'register' &&
            $segment !== 'ajax' &&
            $segment !== 'form' &&
            setting_value("visiosoft.extension.only_members::is_active") &&
            !Auth::check()
        ) {
            return redirect()->route('anomaly.module.users::login');
        }


        return $next($request);


    }
}
