<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleOffersCreateOffersStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'offers',
        'title_column' => 'offered_to_id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        "offered_to" => [
            'required' => true,
        ],
        "offers" => [
            'required' => true,
        ],
    ];

}
