<?php namespace Visiosoft\OffersModule\Offer;

use Visiosoft\OffersModule\Offer\Contract\OfferRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OfferRepository extends EntryRepository implements OfferRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OfferModel
     */
    protected $model;

    /**
     * Create a new OfferRepository instance.
     *
     * @param OfferModel $model
     */
    public function __construct(OfferModel $model)
    {
        $this->model = $model;
    }

    public function getUserOffers($userId) {
        $offers = $this->newQuery()
            ->where('offered_to_id', $userId)
            ->paginate(3);

        foreach ($offers as $offer) {
            $offer->setAttribute('created_at_formatted', $offer->created_at->format(config('streams::datetime.date_format')));
        }

        return $offers;
    }
}
