<?php namespace Visiosoft\OffersModule\Offer;

use Anomaly\Streams\Platform\Entry\EntryCriteria;
use Anomaly\Streams\Platform\Stream\Contract\StreamInterface;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\OffersModule\Offer\Contract\OfferRepositoryInterface;

class OfferCriteria extends EntryCriteria
{

    private $offerRepository;

    public function __construct(
        Builder $query, StreamInterface $stream, $method,
        OfferRepositoryInterface $offerRepository
    )
    {
        parent::__construct($query, $stream, $method);
        $this->offerRepository = $offerRepository;
    }

    public function getUserOffers($userId)
    {
        return $this->offerRepository->getUserOffers($userId);
    }
}
