<?php namespace Visiosoft\OffersModule;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Visiosoft\OffersModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\OffersModule\Offer\OfferRepository;
use Anomaly\Streams\Platform\Model\Offers\OffersOffersEntryModel;
use Visiosoft\OffersModule\Offer\OfferModel;
use Illuminate\Routing\Router;

class OffersModuleServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [];

    /**
     * The addon Artisan commands.
     *
     * @type array|null
     */
    protected $commands = [];

    /**
     * The addon's scheduled commands.
     *
     * @type array|null
     */
    protected $schedules = [];

    /**
     * The addon API routes.
     *
     * @type array|null
     */
    protected $api = [];

    /**
     * The addon routes.
     *
     * @type array|null
     */
    protected $routes = [
        'admin/offers'           => 'Visiosoft\OffersModule\Http\Controller\Admin\OffersController@index',
        'admin/offers/create'    => 'Visiosoft\OffersModule\Http\Controller\Admin\OffersController@create',
        'admin/offers/edit/{id}' => 'Visiosoft\OffersModule\Http\Controller\Admin\OffersController@edit',

        'offers/select' => [
            'as' => 'visiosoft.module.offers::select',
            'uses' => 'Visiosoft\OffersModule\Http\Controller\OffersController@selectOfferAds',
        ],
        'offers/create' => [
            'as' => 'visiosoft.module.offers::create',
            'uses' => 'Visiosoft\OffersModule\Http\Controller\OffersController@create',
        ],
    ];

    /**
     * The addon middleware.
     *
     * @type array|null
     */
    protected $middleware = [
        //Visiosoft\OffersModule\Http\Middleware\ExampleMiddleware::class
    ];

    /**
     * Addon group middleware.
     *
     * @var array
     */
    protected $groupMiddleware = [
        //'web' => [
        //    Visiosoft\OffersModule\Http\Middleware\ExampleMiddleware::class,
        //],
    ];

    /**
     * Addon route middleware.
     *
     * @type array|null
     */
    protected $routeMiddleware = [];

    /**
     * The addon event listeners.
     *
     * @type array|null
     */
    protected $listeners = [
        //Visiosoft\OffersModule\Event\ExampleEvent::class => [
        //    Visiosoft\OffersModule\Listener\ExampleListener::class,
        //],
    ];

    /**
     * The addon alias bindings.
     *
     * @type array|null
     */
    protected $aliases = [
        //'Example' => Visiosoft\OffersModule\Example::class
    ];

    /**
     * The addon class bindings.
     *
     * @type array|null
     */
    protected $bindings = [
        OffersOffersEntryModel::class => OfferModel::class,
    ];

    /**
     * The addon singleton bindings.
     *
     * @type array|null
     */
    protected $singletons = [
        OfferRepositoryInterface::class => OfferRepository::class,
    ];

    /**
     * Additional service providers.
     *
     * @type array|null
     */
    protected $providers = [
        //\ExamplePackage\Provider\ExampleProvider::class
    ];

    /**
     * The addon view overrides.
     *
     * @type array|null
     */
    protected $overrides = [
        //'streams::errors/404' => 'module::errors/404',
        //'streams::errors/500' => 'module::errors/500',
    ];

    /**
     * The addon mobile-only view overrides.
     *
     * @type array|null
     */
    protected $mobile = [
        //'streams::errors/404' => 'module::mobile/errors/404',
        //'streams::errors/500' => 'module::mobile/errors/500',
    ];

    /**
     * Register the addon.
     */
    public function register()
    {
        // Run extra pre-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Boot the addon.
     */
    public function boot()
    {
        // Run extra post-boot registration logic here.
        // Use method injection or commands to bring in services.
    }

    /**
     * Map additional addon routes.
     *
     * @param Router $router
     */
    public function map(Router $router)
    {
        // Register dynamic routes here for example.
        // Use method injection or commands to bring in services.
    }

}
