$(".add-to-offers").on('click', function(){
    let id = $(this).data('adv');
    let title = $(this).data('title');
    let img = $(this).data('img');
    let price = $(this).data('price');
    let jsonText = JSON.parse(localStorage.getItem('offers'));
    if (jsonText) {
        let status = true;
        $.each(jsonText, function(i, item) {
            if(id == item[0]) {
                status = false;
            }
        });
        if (status) {
            jsonText.push([id, title, img, price]);
        }
    } else {
        jsonText = [];
        jsonText.push([id, title, img, price]);
    }
    localStorage.setItem('offers', JSON.stringify(jsonText));
    openOffersSidebar();
});

$(".offers-btn").on('click', function(){
    openOffersSidebar();
});

$('#offersBox').on('click', '.offer-remove', function () {
    newJsonText = [];
    let removeId = $(this).data('remove-id');
    $(this).parent().remove();
    var jsonText = JSON.parse(localStorage.getItem('offers'));
    $.each(jsonText, function (i, item) {
        if(item[0] != removeId){
            newJsonText.push([item[0], item[1], item[2], item[3]]);
        }
    });
    localStorage.setItem('offers', JSON.stringify(newJsonText));
    if (newJsonText.length > 0) {
        $(".offer-btn").attr("disabled", false);
    } else {
        $(".offer-btn").attr("disabled", true);
    }
});

$('body').on('click', '#offersPanelHide', function () {
    $(".offers-btn").removeClass('d-none');
    $("#offersBox").addClass('d-none');
    $("#offerElements li").remove();
});

function openOffersSidebar () {
    $(".offers-btn").addClass('d-none');
    $("#offersBox").removeClass('d-none');
    let jsonText = JSON.parse(localStorage.getItem('offers'));
    $("#offerElements div").remove();
    if(jsonText && jsonText.length > 0) {
        $.each(jsonText, function(i, item) {
            $("#offerElements").append(`
                <div class="item border-bottom py-1">
                    <input type="hidden" name="offersIds[]" value="${item[0]}">
                    <img class="main-photo mr-2" src="${item[2]}">
                    <div class="group text-truncate">
                        <div class="title text-truncate">${item[1]}</div>
                        <span class="price font-weight-bold">${item[3]}</span>
                    </div>
                    <span data-remove-id="${item[0]}"
                        class="del-offer offer-remove border-left position-absolute d-flex align-items-center">
                            <i class="fa fa-times mx-auto" aria-hidden="true"></i>
                    </span>
                </div>
            `);
        });
        $(".offer-btn").attr("disabled", false);
    } else {
        $(".offer-btn").attr("disabled", true);
    }
}