<?php namespace Visiosoft\OffersModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\OffersModule\Offer\Contract\OfferRepositoryInterface;

class ApiController extends PublicController
{
    public function getUserOffers(OfferRepositoryInterface $offerRepository)
    {
        try {
            if (!$userID = request()->user_id) {
                throw new \Exception(trans('visiosoft.module.offers::message.user_id_required'));
            }

            return [
                'success' => true,
                'data' => $offerRepository->getUserOffers($userID),
            ];
        } catch (\Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage(),
            ];
        }
    }
}
