let currRefPage = {}

$('.offers-table').on('click', '.load-more', function () {
    $(this).find('div').show()

    const userID = $(this).data('user_id')
    const currTypePage = currRefPage[userID] || 1

    crudAjax({ page: currTypePage + 1, user_id: userID }, offerLink)
        .then(response => {
            if (response.success) {
                const data = response.data.data
                const offerTable = $(this).closest('tbody')

                for (let i = 0; i < data.length; i++) {
                    offerTable.append(`
                    <tr>
                        <td>${ data[i].id }</td>
                        <td>${ data[i].created_at_formatted }</td>
                    </tr>
                `)
                }

                $(this).closest('tr').remove()

                if (response.data.last_page !== response.data.current_page) {
                    offerTable.append(`
                    <tr class="load-more-wrapper">
                        <td colspan="2">
                            <button class="border-0 w-100 h-100 p-0 load-more d-flex align-items-center justify-content-center"
                                    data-user_id="${ userID }">
                                <div class="spinner-border spinner-border-sm" role="status" style="display: none"></div>
                                ${ loadMoreRefTrans }
                            </button>
                        </td>
                    </tr>
                `)
                }

                currRefPage[userID] = response.data.current_page
            } else {
                alert(response.message)
            }
        })
        .fail(function(xhr, status, error) {
            alert(xhr.responseText)
        })
})
