<?php namespace Visiosoft\OffersModule\Offer;

use Visiosoft\OffersModule\Offer\Contract\OfferRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class OfferRepository extends EntryRepository implements OfferRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var OfferModel
     */
    protected $model;

    /**
     * Create a new OfferRepository instance.
     *
     * @param OfferModel $model
     */
    public function __construct(OfferModel $model)
    {
        $this->model = $model;
    }

    public function getUserOffers($userId) {
        return $this->findAllBy('offered_to_id', $userId);
    }
}
