<?php namespace Visiosoft\OffersModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\DemandModule\Demand\Contract\DemandRepositoryInterface;
use Visiosoft\MessagesModule\Chat\Contract\ChatRepositoryInterface;
use Visiosoft\MessagesModule\Message\Contract\MessageRepositoryInterface;
use Visiosoft\OffersModule\Offer\Contract\OfferRepositoryInterface;
use Visiosoft\OffersModule\Offer\Events\SendOffer;
use Anomaly\UsersModule\User\Contract\UserRepositoryInterface;

class OffersController extends PublicController
{

    private $demandRepository;
    private $offerRepository;
    private $dispatcher;
    private $userRepository;
    private $chatRepository;
    private $messageRepository;

    public function __construct(
        DemandRepositoryInterface $demandRepository,
        OfferRepositoryInterface $offerRepository,
        Dispatcher $dispatcher,
        UserRepositoryInterface $userRepository,
        ChatRepositoryInterface $chatRepository,
        MessageRepositoryInterface $messageRepository
    )
    {
        parent::__construct();
        $this->demandRepository = $demandRepository;
        $this->offerRepository = $offerRepository;
        $this->dispatcher = $dispatcher;
        $this->userRepository = $userRepository;
        $this->chatRepository = $chatRepository;
        $this->messageRepository = $messageRepository;
    }

    public function create()
    {
        $offersIds = request()->offersIds;
        $demandId = request()->demand;
        $offeredTo = $this->demandRepository->find($demandId);
        $offeredTo = $this->userRepository->find($offeredTo->user_id);

        // Create an offer message
        $chat = $this->createChat($offeredTo, $offersIds);

        // Create offer
        $offer = $this->offerRepository->create([
            'demand_id' => $demandId,
            'chat_id' => $chat->id,
            'offered_to' => $offeredTo,
        ]);
        $offer->offers = $offersIds;

        // Send offer mail
        $password = str_random(8);
        $offeredTo->setAttribute('password', $password);
        $offeredTo->save();
        $this->dispatcher->dispatch(new SendOffer($offer, $password));

        $this->messages->success(trans('visiosoft.theme.emlak24::message.offer_sent'));
        return redirect('admin/demand');
    }

    public function createChat($offeredTo, $offersIds)
    {
        // Check if chat exists
        $chat = $this->chatRepository->findChatByUsers($offeredTo->id);
        if (!$chat) {
            $chat = $this->chatRepository->create([
                'user_1_id' => auth()->id(),
                'user_2_id' => $offeredTo->id,
            ]);
        }

        // Send initial message
        $this->messageRepository->create([
            'detail' => trans('visiosoft.theme.emlak24::field.offer_initial_message', ['name' => $offeredTo->name()]),
            'chat_id' => $chat->id,
        ]);

        // Send offered ads
        foreach ($offersIds as $offerId) {
            $this->messageRepository->create([
                'detail' => "/*$offerId",
                'chat_id' => $chat->id,
            ]);
        }

        return $chat;
    }
}
