<?php

namespace Visiosoft\OcTheme\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Illuminate\Http\Request;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Traits\ApiReturnResponseTrait;

class ThemeController extends PublicController
{
    use ApiReturnResponseTrait;

    protected $advRepository;

    public function __construct(AdvRepositoryInterface $advRepository)
    {
        $this->advRepository = $advRepository;
        parent::__construct();
    }

    public function getLanguagePopup(Request $request)
    {
        $inputs = $request->all();
        $ip = $request->ip();
        try {
            $location = file_get_contents("https://ipinfo.io/$ip/json");
            $location = json_decode($location, true);
            $location = [
                'country' => trans('streams::country.' . $location['country']),
                'language' => trans('streams::locale.' . strtolower($location['country']) . '.name'),
                'lang' => strtolower($location['country'])
            ];
            $notification = trans('theme::field.language_popup', ['country' => $location['country'],
                'language' => $location['language']]);
            $locales = config('streams::locales.enabled');
            $popup = [];
            if ($location['lang'] != config('app.locale') && in_array($location['lang'], $locales)) {
                $popup = $this->view->make('theme::popups.language-popups', [
                    'notification' => $notification,
                    'location' => $location,
                    'callback' => $inputs['callback']
                ])->render();
            }
            return $this->sendResponse($popup, '');
        } catch (\Exception $e) {
            return $this->sendExceptionError($e);
        }

    }

    public function ebayLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.ebay_landing"));
        return $this->view->make('theme::landings.ebay');
    }

    public function alibabaLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.alibaba_landing"));
        return $this->view->make('theme::landings.alibaba');
    }

    public function sahibindenLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.sahibinden_landing"));
        return $this->view->make('theme::landings.sahibinden');
    }

    public function carsLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.cars_landing"));
        return $this->view->make('theme::landings.cars');
    }

    public function droverLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.drover_landing"));
        return $this->view->make('theme::landings.drover');
    }

    public function restateLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.restate_landing"));
        return $this->view->make('theme::landings.restate');
    }

    public function pricingPage()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.pricing_page"));
        return $this->view->make('theme::pages.pricing');
    }

    public function contactUsPage()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.contact_us_page"));
        return $this->view->make('theme::pages.contact-us');
    }
}