<?php namespace Visiosoft\OcTheme;

use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Illuminate\Routing\Router;

class OcThemeServiceProvider extends AddonServiceProvider
{

    /**
     * Additional addon plugins.
     *
     * @type array|null
     */
    protected $plugins = [
    	OcThemePlugin::class,
    ];
    protected $routes = [
        '/api/oc-theme/get-language-popup' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@getLanguagePopup',
        '/pricing' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@pricingPage',
        '/ebay-landing' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@ebayLanding',
        '/alibaba-landing' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@alibabaLanding',
        '/cars-landing' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@carsLanding',
        '/drover-landing' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@droverLanding',
        '/sahibinden-landing' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@sahibindenLanding',
        '/restate-landing' => '\Visiosoft\OcTheme\Http\Controller\ThemeController@restateLanding',
    ];
    protected $overrides = [
        'streams::errors/404' => 'visiosoft.theme.oc::content/errors/404',
        'streams::errors/403' => 'visiosoft.theme.oc::content/errors/403',
        'streams::errors/500' => 'visiosoft.theme.oc::content/errors/500',
        'streams::errors/502' => 'visiosoft.theme.oc::content/errors/502',
        'streams::errors/503' => 'visiosoft.theme.oc::content/errors/503',
    ];
}
