<?php namespace Visiosoft\OcTheme\NotificationSeeder;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;

class NotificationSeeder extends Seeder
{
    use DispatchesJobs;
    public function run()
    {
        if (is_module_installed('visiosoft.module.notifications')) {
            $templates = [
                [
                    'en' => [
                        'message' => '<tr align="left" valign="top" height="30">
                                <td width="70"></td>
                                <td style="line-height:20px;font-size:15px;font-style: normal;color:#E6DEFF;font-family:\'Helvetica Neue Light\',Helvetica,Arial,sans-serif;font-weight:400;">
                                    Hi {display_name}!
                                </td>
                                <td width="70"></td>
                            </tr>
                            <tr align="left" valign="top" height="75">
                                <td width="70"></td>
                                <td style="line-height:20px;font-size:15px;font-style: normal;color:#E6DEFF;font-family:\'Helvetica Neue Light\',Helvetica,Arial,sans-serif;font-weight:400;">Your Go marketplace is about to close as your {plan_name} is
                                    about to
                                    end. You and your visitors will no longer be able to visit your
                                    marketplace once it closes.
                                </td>
                                <td width="70"></td>
                            </tr>

                            <tr align="left" valign="top" height="55">
                                <td width="30"></td>
                                <td style="line-height:20px;font-size:15px;font-style: normal;color:#E6DEFF;font-family:\'Helvetica Neue Light\',Helvetica,Arial,sans-serif;font-weight:400;"><a style="color:inherit" href="{{ url(\'/\') }}">Subscribe now</a> to one of the <a href="{{ url(\'/\') }}" style="color:inherit">Ocify.co go plans</a> and keep your
                                    marketplace open!
                                </td>
                                <td width="30"></td>
                            </tr>

                            <tr align="left" valign="top" height="90">
                                <td width="30"></td>
                                <td style="line-height:20px;font-size:15px;font-style: normal;color:#E6DEFF;font-family:\'Helvetica Neue Light\',Helvetica,Arial,sans-serif;font-weight:400;">Or, perhaps, things did not go as planned during the last
                                    30 days,
                                    and you <a href="{{ url(\'/\') }}" style="color:inherit">need some more time?</a> We\'d love to offer some personal
                                    help! Reply to this email to get in touch. We offer support in English,
                                    French, German, and Spanish!
                                </td>
                                <td width="30"></td>
                            </tr>
                            <tr align="center" height="80"></tr>
                            <tr align="center" valign="top" height="10">
                                <td colspan="3" style="font-size:17px;font-style: normal;color:#fff;font-family:\'Helvetica Neue Light\',Helvetica,Arial,sans-serif;font-weight:500;">
                                    Subscribe to one of the Ocify.co Go plans
                                </td>
                            </tr>
                            <tr align="center" valign="top" height="20">
                                <td colspan="3" style="line-height:20px;font-size:13px;font-style: normal;color:#E6DEFF;font-family:\'Helvetica Neue Light\',Helvetica,Arial,sans-serif;font-weight:400;">
                                    Keep your marketplace open and continue with your project.
                                </td>
                            </tr>',
                        'name' => 'Your time is running out - Ocify.co',
                        'greeting' => '',
                        'subject' => 'Need more time and help?'
                    ],
                    'stream' => 'site',
                    'view' => 'visiosoft.theme.oc::notifications.your-time-is-running-out',
                    'slug' => Str::slug('Your time is running out', '_')
                ],
            ];

            foreach ($templates as $template) {
                dispatch_sync(new CreateTemplate($template));
            }
        }
    }
}