$('.selectpickers .list li').on('click', function () {
    let url = new URL(window.location.href);
    let sort_by = url.searchParams.get('sort_by');
    if (url.href.slice(-1) === "#") {
        url = new URL(url.href.slice(0, -1));
    }
    let page = url.searchParams.get('page');
    if (page){
        url.searchParams.delete('page');
    }
    var goURL = "";
    var value = $(this).attr('data-value');
    if (url.search === "") {
        goURL = url.href + "?sort_by=" + value;
    } else if (url.searchParams.has('sort_by')) {
        var parameters = "";
        if (value !== 'all') {
            parameters = "sort_by=" + value;
        }
        goURL = url.href.replace("sort_by=" + sort_by, parameters);
    } else {
        goURL = url + "&sort_by=" + value;
    }
    window.location.replace(goURL);
});

$(() => {
    let searchParams = new URLSearchParams(window.location.search);

    var sort_by = searchParams.get('sort_by');

    if (sort_by != null) {
        let selected = $('.selectpickers .list li[data-value=' + sort_by +']')
        $('.selectpickers .list li').removeClass('selected')
        selected.addClass('selected')
        $('.selectpickers .current').html(selected.html());
    }
});

// Change view type
function changeViewType(viewLink) {
    window.location.href = viewLink
}

function clearSearch() {
  $(".search-input").first().val("");
  
  const urlParams = new URLSearchParams(window.location.search);
  urlParams.delete("keyword");
  window.location.replace(
    window.location.pathname + "?" + urlParams.toString()
  );
}
$(window).on("load", () => {
    $('#category .main-category').on('click', (e) => {
        $(e.currentTarget).toggleClass('active').siblings('.sub-categories').slideToggle(250);
    })

    // If the "All products" button is clicked, disable all the checkboxes in the submenu, and if any of them are disabled, enable all disabled checkboxes.
    $('#category .all-subcat').on('click', (e) => {
        let subMenu = $(e.currentTarget).parents('.sub-categories');
        let disabledItems = subMenu.find('input:disabled');
        subMenu.find('.subcat').attr('disabled', disabledItems.length == 0);
    })
    function getURLParameters(url) {
        const params = new URLSearchParams(url.split('?')[1]);
        const result = {};
        for (const [key, value] of params.entries()) {
            const arrayKey = key.replace(/\[\]$/, '');
            if (key !== arrayKey) {
                result[arrayKey] = result[arrayKey] || [];
                result[arrayKey].push(value);
            } else {
                result[key] = value;
            }
        }
        return result;
    }

    const queryParams = getURLParameters(window.location.href);
    const cats = queryParams.cats || [];

    //Convert the cats from the queryParams into a single array.
    if(cats.length == 0 && queryParams['cats[0]']){
        let i = 0;
        while (queryParams['cats['+i+']']) {
            cats.push(queryParams['cats['+i+']']);
            i++;
        }
    }

    cats.forEach(cat => {

        let parent_category = $('#' + cat).parents('.category')

        // If all categories button are selected, select all subcategories.
        // If all but one of the checkboxes are checked in the subcategory list, select all subcategories.
        if ($('#' + cat).hasClass('all-subcat')  ){
            parent_category.find('.sub-categories .subcat').attr('disabled', true);
        }

        $('#' + cat).prop('checked',true);

        // If the active class of the parent category of the categories in the URL is not present, add the active class and expand the subcategories list.
        if(!parent_category.find('.main-category').hasClass('active')){
            parent_category.find('.main-category').addClass('active').siblings('.sub-categories').slideToggle(250);
        }


    })
})