<?php

namespace Visiosoft\OcTheme\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Traits\ApiReturnResponseTrait;

class ThemeController extends PublicController
{
    use ApiReturnResponseTrait;

    protected $advRepository;

    public function __construct(AdvRepositoryInterface $advRepository)
    {
        $this->advRepository = $advRepository;
        parent::__construct();
    }

    public function ebayLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.ebay_landing"));
        return $this->view->make('theme::landings.ebay');
    }

    public function alibabaLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.alibaba_landing"));
        return $this->view->make('theme::landings.alibaba');
    }

    public function sahibindenLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.sahibinden_landing"));
        return $this->view->make('theme::landings.sahibinden');
    }

    public function carsLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.cars_landing"));
        return $this->view->make('theme::landings.cars');
    }

    public function droverLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.drover_landing"));
        return $this->view->make('theme::landings.drover');
    }

    public function restateLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.restate_landing"));
        return $this->view->make('theme::landings.restate');
    }

    public function pricingPage()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.pricing_page"));
        return $this->view->make('theme::pages.pricing');
    }

    public function contactUsPage()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.contact_us_page"));
        return $this->view->make('theme::pages.contact-us');
    }
}