$('.selectpickers .list li').on('click', function () {
    let searchParams = new URLSearchParams(window.location.search);
    var sort_by = searchParams.get('sort_by');
    var url = window.location.href;
    if (url.slice(-1) === "#") {
        url = url.slice(0, -1);
    }
    var goURL = "";
    var value = $(this).attr('data-value');
    if (window.location.search === "") {
        goURL = url + "?sort_by=" + value;
    } else if (searchParams.has('sort_by')) {
        var parameters = "";
        if (value !== 'all') {
            parameters = "sort_by=" + value;
        }
        goURL = location.href.replace("sort_by=" + sort_by, parameters);
    } else {
        goURL = url + "&sort_by=" + value;
    }
    window.location.replace(goURL);
});

$(() => {
    let searchParams = new URLSearchParams(window.location.search);

    var sort_by = searchParams.get('sort_by');

    if (sort_by != null) {
        let selected = $('.selectpickers .list li[data-value=' + sort_by +']')
        $('.selectpickers .list li').removeClass('selected')
        selected.addClass('selected')
        $('.selectpickers .current').html(selected.html());
    }
});

// Change view type
function changeViewType(viewLink) {
    window.location.href = viewLink
}

function clearSearch() {
  $(".search-input").first().val("");
  
  const urlParams = new URLSearchParams(window.location.search);
  urlParams.delete("keyword");
  window.location.replace(
    window.location.pathname + "?" + urlParams.toString()
  );
}