<?php

namespace Visiosoft\OcTheme\Http\Controller;

use \Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\AdvsModule\Traits\ApiReturnResponseTrait;

class ThemeController extends PublicController
{
    use ApiReturnResponseTrait;

    protected $advRepository;

    public function __construct(AdvRepositoryInterface $advRepository)
    {
        $this->advRepository = $advRepository;
        parent::__construct();
    }

    public function marketplacexLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.marketplacex_landing"));
        return $this->view->make('theme::landings.marketplaceX');
    }

    public function carxLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.carx_landing"));
        return $this->view->make('theme::landings.carX');
    }

    public function estatexLanding()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.estatex_landing"));
        return $this->view->make('theme::landings.estateX');
    }

    public function pricingPage()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.pricing_page"));
        return $this->view->make('theme::pages.pricing');
    }

    public function contactUsPage()
    {
        $this->template->set('meta_title', trans("visiosoft.theme.oc::pages.contact_us_page"));
        return $this->view->make('theme::pages.contact-us');
    }
    
    public function loginPage()
    {
        return $this->redirect->route('anomaly.module.users::login', ['modal'=>true]);
    }
}