<?php namespace Visiosoft\OcTheme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\OcTheme\Handler\getRandomBlock;
use Visiosoft\OcTheme\Handler\pagesFindBySlug;

class OcThemePlugin extends Plugin
{

    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'pagesFindBySlug',
                function ($slug) {
                    return $this->dispatch(new pagesFindBySlug($slug));
                }
            ),
            new \Twig_SimpleFunction(
                'getRandomBlock',
                function ($slug) {
                    return $this->dispatch(new getRandomBlock($slug));
                }
            ),
            new \Twig_SimpleFunction(
                'getAdsPhoto',
                function ($adv) {
                    $photos = $adv->getViewPhotoUrl;
                    if ($adv->category1->slug->value === 'modules') {
                        array_shift($photos);
                    }
                    return $photos;
                }
            )
        ];
    }
}
