var Animation = function ({ offset } = { offset: 10 }) {
    var _elements;

    // Adjusts the top, bottom, and sides of the canvas
    var windowTop = offset * window.innerHeight / 100;
    var windowBottom = window.innerHeight - windowTop;
    var windowLeft = 0;
    var windowRight = window.innerWidth;

    function start(element) {
        // Set custom attributes
        element.style.animationDelay = element.dataset.animationDelay;
        element.style.animationDuration = element.dataset.animationDuration;
        // Start the animation by entering the animation class
        element.classList.add(element.dataset.animation);
        // Set item to animate
        element.dataset.animated = "true";
    }

    function isElementOnScreen(element) {
        // Gets the bounding box of the item
        var elementRect = element.getBoundingClientRect();
        var elementTop =
            elementRect.top + parseInt(element.dataset.animationOffset) ||
            elementRect.top;
        var elementBottom =
            elementRect.bottom - parseInt(element.dataset.animationOffset) ||
            elementRect.bottom;
        var elementLeft = elementRect.left;
        var elementRight = elementRect.right;

        // Checks if the item is on the screen
        return (
            elementTop <= windowBottom &&
            elementBottom >= windowTop &&
            elementLeft <= windowRight &&
            elementRight >= windowLeft
        );
    }

    // Loops through array of elements, checks if element is on screen, and starts animation
    function checkElementsOnScreen(els = _elements) {
        for (var i = 0, len = els.length; i < len; i++) {
            // Jumps to next loop if item is already animated
            if (els[i].dataset.animated) continue;

            isElementOnScreen(els[i]) && start(els[i]);
        }
    }

    // Updates the list of items to animate
    function update() {
        _elements = document.querySelectorAll(
            "[data-animation]:not([data-animated])"
        );
        checkElementsOnScreen(_elements);
    }

    // start events
    window.addEventListener("load", update, false);
    window.addEventListener("scroll", () => checkElementsOnScreen(_elements), { passive: true });
    window.addEventListener("resize", () => checkElementsOnScreen(_elements), false);

    // Returns generic functions
    return {
        start,
        isElementOnScreen,
        update
    };
};

// start
var options = {
    offset: 20 // window percentage
};
var animation = new Animation(options);