$(() => {
    $('.top-banner').slick({
        infinite: true,
        autoplay: true,
        autoplaySpeed: 2000,
        arrows: false,
        lazyLoad: 'progressive',
    }).removeClass('d-none');

    const sView = $("#sView");
    if (sView.length) {
        setTimeout(() => {
            $('html, body').animate({
                scrollTop: sView.offset().top
            }, 500);
        }, 500)
    }

    if ($('.curved-landing-lid .landing-mobile-icon').css('display') !== 'none') {
        $('.curved-landing-lid').on('click', (() => {
            $('.curved-landing-lid').toggleClass('curved-landing-lid-show');
            $('.curved-landing-lid .landing-mobile-icon .down-icon').toggleClass('arrow_carrot-2up arrow_carrot-2down')
        }))
    }

    $('.all-lang-flags').slick({
        slidesToShow: 7,
        slidesToScroll: 1,
        dots: false,
        arrow: false,
        centerMode: true,
        centerPadding: "0",
        speed: 800,
        autoplay: true,
        autoplaySpeed: 2000,
        infinite: true,
        lazyLoad: 'progressive',
        prevArrow:"<i class='ti-arrow-left prevs slick-arrow'></i>",
        nextArrow:"<i class='ti-arrow-right nexts slick-arrow' ></i>",
        responsive: [
            {
                breakpoint: 1008,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    centerMode: true,
                    centerPadding: "150px",
                },
            },
            {
                breakpoint: 577,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    centerMode: true,
                    centerPadding: "30px",
                },
            },
        ],
    });

    $('#recomd-ads').slick({
        slidesToShow: 4,
        slidesToScroll: 1,
        dots: false,
        arrow: false,
        centerMode: true,
        centerPadding: "0",
        speed: 800,
        autoplay: false,
        autoplaySpeed: 2000,
        infinite: true,
        lazyLoad: 'progressive',
        prevArrow:"<div class='ads-arrow left'><i class='ti-angle-left prevs slick-arrow'></i> </div>",
        nextArrow:"<div class='ads-arrow right'><i class='ti-angle-right nexts slick-arrow' ></i> </div>",
        responsive: [
            {
                breakpoint: 768,
                settings: {
                    slidesToShow: 3,
                    slidesToScroll: 1,
                    centerMode: true,
                },
            },
            {
                breakpoint: 425,
                settings: {
                    slidesToShow: 2,
                    slidesToScroll: 1,
                    centerMode: true,
                },
            },
        ],
    });

    if ($('#bannerTypewriter').length) {
        new Typewriter('#bannerTypewriter', {
            strings: ['Classified', 'Open Source'],
            autoStart: true,
            wrapperClassName:'Typewriter__wrapper notranslate',
            loop: true,
            cursorClassName: 'Typewriter__cursor font-weight-light pr-1'
        });
    }

    let resetRadio = $('#resetType input[type="radio"]:checked').val();

    $('input[type="radio"][name=resetTypeRadio]').on('change', () => {
        $('.resetForm').toggleClass('d-none');
    });

    crudAjax({}, '/api/get-sites-by-assign', 'GET', function (data) {
        $('.checkout_button, .checkout_button_nav')
            .removeAttr('data-target data-toggle')
            .attr('href', '/cart/review');

        $.each(data, function (key, value) {
            $('select[name="cart_option__site_select"]').html(
                `<option value="${value.id}">${value.subdomain_name}.${value.type} (${value.status})</option>`
            ).niceSelect()
        });
    })

    confirmPassword();

})

$(document).on('click', '.cart-remove-btn', (e) => {
    let item_id = $(e.target.closest('.cart-remove-btn')).attr('data-id');
    let adv_id = $(e.target.closest('.cart-remove-btn')).attr('data-type');
    let cart_count = $('.cart-badge')
    $.ajax({
        type: 'POST',
        url: '/cart/quantity',
        data: 'id=' + item_id + '&quantity=0&type=remove&currency=1',
        success: function (data) {

            $('.dropdown-cart-menu').find('.subtotal').html(`${data.cart.currency_subtotal}`)
            $('#' + item_id).remove();
            if ($('#btn' + adv_id).length) {
                $('#btn' + adv_id).removeAttr('disabled').html(addCartText);
            }
            let newCount = parseInt($('.cart-badge').html()) - 1;
            if (newCount > 0) {
                cart_count.html(newCount);
            } else {
                $('#dropdownCartMenu').parent().removeClass('d-lg-flex').addClass('d-none');
            }

        }
    });
})

$(document).ready(function(){
    $(".cart-hover").hover(function(){
        $(".dropdown-cart-menu").toggleClass('show');
    });
});

const addCart = (id, type = null) => {
    let url;
    let data;
    if (type === 'bundle') {
        url = '/add-cart/bundle';
        data = {
            'bundle': id,
            'theme': 'oc',
        }
    } else {
        url = '/ajax/addCart';
        data = {
            'id': id,
            'quantity': 1,
        }
    }
    cartAjax(id, url, data)
}

const cartAjax = (id, url, data) => {
    $.ajax({
        type: 'POST',
        url: url,
        data: data,
        success: function (data) {
            console.log(data)
            if (data.status === "success") {
                Swal.fire({
                    icon: data.status,
                    title: cartSuccessMessage,
                    showConfirmButton: false,
                    timer: 1500
                })
                if ($('#btn' + id).length) {
                    $('#btn' + id).attr('disabled', 'true').html(disabledCartText);
                }
                let cartMenu = $('.dropdown-cart-menu');

                cartMenu.find('.cart-item').append(`
                    <li id="${data.item.id}" class="dropdown-item d-flex">
                        <div>
                            <img src="${data.item.photo}" height="90" alt="">
                        </div>
                    <div class="d-flex flex-column justify-content-around ml-3">
                        <a href="${data.item.url}" class="text-dark">${data.item.name.substring(0,25) + '...'}</a>
                        <span class="text-black-50">${data.item.quantity} x <span class="cart-modal-price">${data.item.price}</span></span>
                    </div>
                    <div class="d-flex align-items-center ml-4">
                        <a href="javascript:void(0);" class="cart-remove-btn text-dark" data-type="${data.item.adv_id}" data-id="${data.item.id}"><i class="icon_close"></i></a>
                    </div>
                    </li>
                `)

                cartMenu.find('.subtotal').html(`${data.item.subtotal}`)

                $('.cart-badge').html(data.count)

                if (!$('#dropdownCartMenu').parent().hasClass('d-lg-flex')) {
                    $('#dropdownCartMenu').parent().removeClass('d-none').addClass('d-lg-flex')
                }
            } else {
                Swal.fire({
                    icon: 'error',
                    title: data.msg,
                    showConfirmButton: false,
                    timer: 1500
                })
            }
        }
    });
}

if ($('#flipper')) {
    $('.flipper').css('height', $('.login_area').height() + 200)

    $('#loginButton').on('click', () => {
        $('.flipper').css('height', $('.register_area').height() + 200)
        $('#flipper').toggleClass('flip');
    })

    $('#registerButton').on('click', () => {
        $('.flipper').css('height', $('.login_area').height() + 200)
        $('#flipper').toggleClass('flip');
    })
}

getUserNavMenu(`
                <span class="d-lg-flex align-items-center dropdown">
                    <li class="nav-item mega_menu mega_menu_two user d-lg-flex d-none align-items-center dropdown"
                        id="dropdownProfileMenu" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">

                        <a class="nav-link username d-block mr-2" href="${profileRoute}" role="button"
                           aria-haspopup="true" aria-expanded="false">
                        </a>
                        <span>
                            <img src="#" alt="Profile Photo" width="43" height="43" class="custom-border-1 profile-img">
                        </span>
                    </li>
                    <span class="dropdown-menu" aria-labelledby="dropdownProfileMenu">
                        <a class="dropdown-item" href="${profileRoute}">
                            ${myProfileTrans}
                        </a>
                        <span class="addBlock"></span>
                        <a class="dropdown-item text-black-50" href="${logoutRoute}">
                            ${logoutTrans}
                        </a>
                    </span>
                </span>
                <span class="d-none align-items-center ml-lg-5">
                    <a class="nav-link text-black-50 mr-2 username" href="${profileRoute}" role="button"
                       aria-haspopup="true" aria-expanded="false">
                    </a>
                </span>
                <span class="d-none d-lg-none align-items-center ml-lg-5">
                    <a class="text-black-50" href="${logoutRoute}">
                        ${logoutTrans}
                    </a>
                </span>`, $('.user-nav-menu'));

const confirmPassword = () => {

    $(".register-form input[name=confirm_password], .register-form input[name=password] ").on("keyup",() => {
        var password = $(".register-form input[name=password]");
        var confirmPassword = $(".register-form input[name=confirm_password]");
        var loginButton = $(".register-form .btn_three");
        var confirmMessage = $(".register-form .confirm-msg");

        if( password.val() == confirmPassword.val() && password.val().length >= 8 ) {
            loginButton.attr('disabled',false).removeClass('btn-disabled');
            confirmPassword.removeClass('border-danger')
            password.removeClass('border-danger');
            confirmMessage.html("");
        } else {
            loginButton.attr('disabled',true).addClass('btn-disabled');
            confirmPassword.addClass('border-danger');
            password.addClass('border-danger');
            confirmMessage.html(confirmError);
        }

    });

    $(".js-show").on("click", (e) => {
        var input = $(e.currentTarget).siblings("input");
        var type = input.attr('type');
        input.attr('type', type == 'text' ? 'password' : 'text');
    });

}

const resourcesPageNavigation = () => {
    if (window.location.pathname === '/resources') {
        let hash = window.location.hash;
        if (!hash){
            $('#resources ul li a').on("click",function($item){
                $(`.tab-pane`).removeClass('show active');
                let id = ($item).currentTarget.id;
              $( `.tab-pane#${id}-tab-pane`).addClass('show active');
            });
        }else{
            $(`.tab-pane`).removeClass('show active');
            $(`#resources ul li a`).removeClass('active');
            $(`#resources ul li a${hash}-tab`).addClass('active');
            $(`.tab-pane${hash}`).addClass('show active')
        }
    }
}

resourcesPageNavigation();
