let site_locale = 'en', vstore = {}, iti;

$(function () {
    initClickEvents();

    initDigitInputs();

    setPhoneFieldAttr();

    // $(document).on('click', '.next_third_step', function () {
    //     $('#freeTrialModal .modal-dialog').addClass('modal-lg')
    // });

});

function informationSubdomain() {
    $('#informationSubdomainModal').modal('show')
}

function validateEmail($email) {
    var emailReg = /^([\w-\.]+@([\w-]+\.)+[\w-]{2,4})?$/;
    return emailReg.test($email);
}

function initDigitInputs() {
    $('.digit-input').each(function () {

        $(this).attr('maxlength', 1);

        $(this).on('keyup', function (e) {

            limitText(this, 1);

            let filled = true;

            $('.digit-input').each(function (index, element) {
                let ref = $(element),
                    val = ref.val();

                if (val.length === 0) {
                    filled = false;
                    $('.activation-action-btn').addClass('disabled').prop('disabled', true);
                }
            });

            if (filled) {
                $('.activation-action-btn').removeClass('disabled').prop('disabled', false);
            }

            let parent = $($(this).parent());

            if (e.keyCode === 8 || e.keyCode === 37) {
                let prev = parent.find('input#' + $(this).data('previous'));
                if (prev.length) {
                    $('.activation-action-btn').addClass('disabled').prop('disabled', true);
                    $(prev).select();
                }
            } else if (
                (e.keyCode >= 48 && e.keyCode <= 57)
                || (e.keyCode >= 65 && e.keyCode <= 90)
                || (e.keyCode >= 96 && e.keyCode <= 105)
                || e.keyCode === 39) {
                let next = parent.find('input#' + $(this).data('next'));
                if ($(this).val().length && next.length > 0) {
                    $(next).select();
                }
            }
        });

    });
}

function setPhoneFieldAttr() {
    let country = document.getElementById('default-phone-country')
        ? document.getElementById('default-phone-country').innerText : null;

    let phone = document.getElementById('phone');

    iti = intlTelInput(phone, {
        class: "phone",
        initialCountry: "auto",
        formatOnDisplay: true,
        nationalMode: true,
        hiddenInput: phone.name,
        utilsScript: 'utils/utils.js',
        geoIpLookup: function (success, failure) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = country ? country : (resp && resp.country) ? resp.country : "";
                success(countryCode);
            })
        }
    });

    addMask(iti, phone);

    $(phone).on("countrychange", function (event) {
        iti.setNumber("");
        addMask(iti, phone);
    });

    function addMask(iti, phone) {
        let selectedCountryData = iti.getSelectedCountryData();
        let newPlaceholder = intlTelInputUtils.getExampleNumber(selectedCountryData.iso2, true, intlTelInputUtils.numberFormat.INTERNATIONAL);
        $(phone).inputmask({mask: newPlaceholder.replace(/[0-9+]/ig, '9'), keepStatic: false});
    }

    function controlNumber(phone) {
        var iti = intlTelInput(phone, {
            hiddenInput: phone.getAttribute('name'),
            class: "phone",
            initialCountry: "auto",
            geoIpLookup: function (success, failure) {
                $.get("https://ipinfo.io", function () {
                }, "jsonp").always(function (resp) {
                    var countryCode = (resp && resp.country) ? resp.country : "";
                    success(countryCode);
                })
            }
        });

        return iti.isValidNumber();
    }
}

function limitText(field, maxChar) {
    let ref = $(field),
        val = ref.val();
    if (val.length >= maxChar) {
        ref.val(function () {
            return val.substr(0, maxChar);
        });
    }
}

function resetErrors() {

    let fieldErrors = $('.formErrors.field'),
        termOfUseErrors = $('.formErrors.term_of_use_error'),
        formModal = $('#freeTrialModal');

    fieldErrors.html('');
    termOfUseErrors.html('');
    formModal.find('.error-message').html('');
    formModal.find('.form-error').removeClass('form-error');
}

function countdown(elementName, minutes, seconds) {
    var element, endTime, hours, mins, msLeft, time;

    function twoDigits(n) {
        return (n <= 9 ? "0" + n : n);
    }

    function updateTimer() {
        msLeft = endTime - (+new Date);
        if (msLeft < 1000) {
            element.innerHTML = "";
        } else {
            time = new Date(msLeft);
            hours = time.getUTCHours();
            mins = time.getUTCMinutes();
            element.innerHTML = (hours ? hours + ':' + twoDigits(mins) : mins) + ':' + twoDigits(time.getUTCSeconds());
            setTimeout(updateTimer, time.getUTCMilliseconds() + 500);
        }
    }

    element = document.getElementById(elementName);
    endTime = (+new Date) + 1000 * (60 * minutes + seconds) + 500;
    updateTimer();
}

function timerResend() {
    let second = 120;

    $('.resend-verify').attr('disabled', true);
    countdown("verify-countdown", 0, second);
    setTimeout(function () {
        $('.resend-verify').attr('disabled', false);
    }, second * 1000);
}

function renderError(reject) {
    let formModal = $('#freeTrialModal');

    $.each($.parseJSON(reject.responseText).errors, (key, msg) => {
        key = (key === 'storename' ? 'subdomain' : key);
        formModal.find('input[name="' + key + '"]').addClass('form-error');
        formModal.find('.error-' + key).html(msg);
        formModal.find('select[name="' + key + '"]').addClass('form-error');
    });
}

function resetActivationErrors() {
    $('.activation-errors').html('').addClass('d-none');
}

function checkSiteStatus(pid) {
    return new Promise((resolve, reject) => {
        return $.ajax({
            url: '/ajax/get-site-status/' + pid,
            method: 'get',
            accept: 'application/json',
            success: (response) => {
                if (response.success) {
                    resolve(response.result);
                }
                reject(response)
            },
            error: (xhr, status, error) => {
                reject(JSON.parse(xhr.responseText))
            }
        })
    })
}

function completeProgress(response) {
    return new Promise((resolve) => {
        $('.sixth_step .site-url').html(response.url);
        $('.sixth_step .open-site').attr('href', response.address)
        $('.sixth_step #email-address').html(response.email)
        $('.sixth_step #site-password').html(response.password)
        $('.sixth_step .site-admin-login').attr('href', response.admin_login)
        setTimeout(function () {
            resolve()
        }, 2000)
    })
}

function setProgressInterval() {
    let error = false;
    let c = 0;
    let progressInterval = setInterval(function () {
        if (c < 99 && !error) {
            c = c + 1;
            $('#installingProgressBar').html(c + '%');
            $('.progress-bar').css('width', c + '%');
        }
        checkSiteStatus(vstore.pid).then(response => {
            if (response) {
                c = 100;
                $('#installingProgressBar').html(c + '%');
                $('.progress-bar').css('width', c + '%');

                completeProgress(response).then(() => {
                    setTimeout(function () {
                        $('.fifth_step').addClass('d-none');
                        $('.sixth_step').removeClass('d-none');
                        clearInterval(progressInterval)
                    }, 5000);
                })
            }
        }).catch(errors => {
            error = true;
            clearInterval(progressInterval);
            $('.fifth_step').addClass('d-none');
            $('.error_step').removeClass('d-none');
        })
    }, 3000)
}

function getEnteredVerificationCode() {
    let code;
    code = $('#digit-1').val();
    code += $('#digit-2').val();
    code += $('#digit-3').val();
    code += $('#digit-4').val();
    code += $('#digit-5').val();
    code += $('#digit-6').val();

    return code;
}

function initClickEvents() {
    // Opening Event
    $('#freeTrialModal').on('shown.bs.modal', function (e) {
        if ($('.landing-email').length) {
            let value_email = $('.landing-email input').val();
            $('#ocTrialForm').find('input[name="email"]').val(value_email);
        }
    });

    $('.activation-action-btn').on('click', function () {

        $('.activation-action-btn').prop('disabled', true);

        $.ajax({
            url: '/ajax/user-verification',
            method: 'POST',
            data: {
                verification_code: getEnteredVerificationCode(),
                pid: vstore.pid
            },
            accept: 'application/json',
            beforeSend: () => {
                $('.digit-input').prop('disabled', true);
                resetActivationErrors();
            },
            success: (response) => {
                if (response.success) {
                    setProgressInterval();
                    $('.fourth_step, .fifth_step').toggleClass('d-none');
                }
            },
            error: (error) => {
                let errorElement = $('.activation-errors');
                $.each($.parseJSON(error.responseText).errors, function (i, v) {
                    errorElement.append(`${v}`);
                });
                errorElement.removeClass('d-none');
            },
            complete: function (data) {
                $('.digit-input').prop('disabled', false);
            }
        })
    });

    $('.resend-verify').on('click', function () {
        crudAjax({}, '/ajax/resend-verify-sms/' + vstore.pid, 'GET', function (r) {
            if (r.status) {
                timerResend();
            }
        }, true);
    });

    $('.next_second_step').on('click', function () {

        let fieldErrors = $('.formErrors.field'),
            termOfUseErrors = $('.formErrors.term_of_use_error'),
            formModal = $('#freeTrialModal'),
            formSubdomainValue = formModal.find('input[name="subdomain"]').val(),
            formDomainValue = formModal.find('select[name="domain"]').val(),
            formEmailValue = formModal.find('input[name="email"]').val(),
            formNameValue = formModal.find('input[name="name"]').val(),
            formSurnameValue = formModal.find('input[name="surname"]').val(),
            formPhoneValue = iti.getNumber(),
            formTermOfUseValue = formModal.find('input[name="term_of_use"]:checked').val();

        formModal.find('.form-control').focus(function () {
            $(this).removeClass('form-error');
        });

        if (formTermOfUseValue !== 'true') {
            termOfUseErrors.html("<p class='mb-0'><i class='fa fa-exclamation-triangle'></i>" + errorList['term_of_use'] + "</p>");
        }

        if (formTermOfUseValue) {
            $.ajax({
                type: 'POST',
                data: {
                    storename: formSubdomainValue,
                    domain: formDomainValue,
                    email: formEmailValue,
                    name: formNameValue,
                    surname: formSurnameValue,
                    phone: formPhoneValue
                },
                url: '/ajax/trial-register-validate',
                beforeSend: function () {
                    resetErrors();
                },
                success: function (response) {
                    if (!response.status) {
                        $.each(response.errors, (key, msg) => {
                            fieldErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + msg + "</p>");
                        });
                    } else {
                        formModal.find('.modal-dialog').addClass('modal-lg');
                        if (typeof auto_select_bundle_id !== 'undefined') {
                            $('.one_step, .three_step').toggleClass('d-none');
                        } else {
                            $('.one_step, .two_step').toggleClass('d-none');
                        }
                    }
                }, error: function (reject) {
                    renderError(reject)
                }
            })
        }
    });

    $('.prev_one_step').on('click',function (){
        // $('.modal-dialog').removeClass('modal-lg');
        $('.one_step, .two_step').toggleClass('d-none');
    })

    $('.next_third_step').on('click', function () {
        $('.two_step, .fourth_step').toggleClass('d-none');
        handleTrial();
    });


    $('.next-fourth').on('click', function () {
        site_locale = $('.lang_select_area').find('input:checked').val();
        handleTrial();

        $('.three_step, .fourth_step').toggleClass('d-none');
    });
}

$(document).ready(function() {
    $(".next_third_step").attr("disabled","disabled");
    var bundle_package = $("#freeTrialModal input[name='bundle']");
    bundle_package.each(function() {
        $(this).change(function(){
            $(".next_third_step").prop("disabled", false);
            $(".next_third_step").removeClass("disabled");
        });
    });
});
function handleTrial() {
    ///////////////////////////////////////////////////////////////////////////////////////
    // todo: activate yandex metrica later #### important: i disabled it in my localhost ///
    // ym(66363319, 'reachGoal', 'trialFormSubmitted');////////////////////////////////////
    ///////////////////////////////////////////////////////////////////////////////////////

    let formErrors = $('.formErrors'), form = $('#ocTrialForm'),
        formEmailValue = form.find('input[name="email"]').val(),
        formNameValue = form.find('input[name="name"]').val(),
        formSurnameValue = form.find('input[name="surname"]').val(),
        formPhoneValue = iti.getNumber();

    formPhoneValue = formPhoneValue.substring(1);

    let formSubdomainValue = (form.attr('id') === 'ocTrialForm') ? $("input[name='subdomain']").val() : $("input[name='storename']").val();

    formSubdomainValue = formSubdomainValue.replace(/[^a-zA-Z0-9]/g, "").replace(/ /g, '');

    let formThemeValue = $('#freeTrialModal input[name="bundle"]:checked').val();

    if (typeof auto_select_bundle_id != "undefined") {
        formThemeValue = auto_select_bundle_id;
    }


    /*** Validation Email */
    if (validateEmail(formEmailValue)) {

        var passthrough = {
            'name': formNameValue,
            "surname": formSurnameValue,
            "email": formEmailValue,
            'storename': formSubdomainValue,
            'phone': formPhoneValue,
            'theme': formThemeValue,
            'locale': site_locale,
        };
        $.ajax({
            type: 'POST',
            data: passthrough,
            url: '/ajax/trial-register',
            beforeSend: function () {
                $('#freetrialForm,  #ocTrialForm').find('.submitBtn').prop("disabled", true);
                timerResend();
                resetActivationErrors();
            },
            error: () => {
                $('.fourth_step').addClass('d-none');
                $('.error_step').removeClass('d-none');
            },
            success: function (c) {
                formErrors.html("");
                if (c.status) {
                    vstore.pid = c.vid;
                    registeredUserEmail = c.data.email
                    storeName = c.data.storename
                } else {
                    /*** Show Error Icon */
                    if (c.type) {
                        $.each(c.type, function (i, t) {
                            if (t === false) {
                                $('.' + i).removeClass('d-none');
                                formErrors.append("<p><i class='fa fa-exclamation-triangle'></i>" + errorList[i] + "</p>");
                            } else {
                                if (!$('.' + i).hasClass('d-none')) {
                                    $('.' + i).addClass('d-none');
                                }
                            }
                        });
                    } else {
                        formErrors.append(`<p><i class='fa fa-exclamation-triangle'></i>${c.message}</p>`);
                    }
                }
            },
            complete: function () {
                $('#freetrialForm').find('.submitBtn').prop("disabled", false);
                $('#freetrialForm, #ocTrialForm').find('.submitBtn').prop("disabled", false);
            }
        });
    }
}



$("#addon_install").submit((e) => {
    e.preventDefault();
    const site = $("select[name='site']").val();
    const addon = $("input[name='addon']").val();
    $.ajax({
        type: 'POST',
        url: '/api/add-addon',
        data: {site, addon},
        success: (response) => {
            Swal.fire({
                icon: 'success',
                title: site_translation_fields['theme_installation_success'],
                timerProgressBar: true,
                showConfirmButton: false,
                timer: 5500
            })
        },
        error: (err) => {
            Swal.fire({
                icon: 'error',
                title: site_translation_fields['theme_installation_error'],
                timerProgressBar: true,
                showConfirmButton: false,
                timer: 5500
            })
        }
    })
})

$(document).ready(function(){
    $('.input-group input').focus(function(){
        me = $(this) ;
        $("label[for='"+me.attr('id')+"']").addClass("animate-label");
    });
    $('.input-group input').blur(function(){
        me = $(this) ;
        if ( me.val() == ""){
            $("label[for='"+me.attr('id')+"']").removeClass("animate-label");
        }
    });
})
