$(document).on('ajaxComplete ready', function () {

    let element = $('#storename');

    $('input[data-provides="anomaly.field_type.slug"]:not([data-initialized])').each(function () {

        $(this).attr('data-initialized', '');

        var config = {
            slug: this,
            lowercase: $(this).data('lowercase')
        };

        /**
         * Only slugify other fields if
         * value is empty OR configured
         * to always slugify field values.
         */
        if (!$(this).val() || $(this).data('always_slugify')) {
            config.slugify = '[data-field="' + $(this).data('slugify') + '"]:visible:first';
        }

        // Slugify slug inputs.
        $(this).slugify(config);
    });

    element.on('change keyup', function () {
        let value = (element.val() === '') ? 'example' : element.val();
        $('.preview .preview-domain').text(value);
    });

});

function selectBundle(id) {
    $('.bundle').removeClass('active');

    if (!$('.bundle[id="' + id + '"]').hasClass('active')) {
        $('.bundle[id="' + id + '"]').addClass('active');
    }
}

function selectLanguage(locale) {
    $('.locale').removeClass('default-language');

    if (!$('.locale[id="' + locale + '"]').hasClass('default-language')) {
        $('.locale[id="' + locale + '"]').addClass('default-language');
    }
}