<?php namespace Visiosoft\OcTheme;

use Anomaly\Streams\Platform\Addon\Plugin\Plugin;
use Visiosoft\AdvsModule\Adv\AdvModel;
use Visiosoft\AdvsModule\Adv\Contract\AdvRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Command\getFieldsByAd;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;
use Visiosoft\OcTheme\Handler\getRandomBlock;
use Visiosoft\OcTheme\Handler\pagesFindBySlug;
use Visiosoft\SiteModule\Addon\Contract\AddonRepositoryInterface;

class OcThemePlugin extends Plugin
{

    protected $adv;
    protected $cf;
    protected $addon;
    public function __construct(
        AdvModel $adv,
        CustomFieldRepositoryInterface $cf,
        AddonRepositoryInterface $addon
    ){
        $this->adv = $adv;
        $this->cf = $cf;
        $this->addon = $addon;
    }
    public function getFunctions(): array
    {
        return [
            new \Twig_SimpleFunction(
                'pagesFindBySlug',
                function ($slug) {
                    return dispatch_sync(new pagesFindBySlug($slug));
                }
            ),
            new \Twig_SimpleFunction(
                'getRandomBlock',
                function ($slug) {
                    return dispatch_sync(new getRandomBlock($slug));
                }
            ),
            new \Twig_SimpleFunction(
                'getAdsPhoto',
                function ($adv) {
                    $photos = $adv->getViewPhotoUrl;
                    if ($adv->category1->slug->value === 'modules') {
                        array_shift($photos);
                    }
                    return $photos;
                }
            ),
            new \Twig_SimpleFunction(
                'getAllSiteAddons',
                function ($site_id) {
                    $addons = $this->adv->newQuery()
                        ->where('deleted_at', null)
                        ->where('status', '=', 'approved')
                        ->where('slug', '!=', '')
                        ->get();

                    foreach ($addons as $addon) {
                        $composerName = $this->cf->getAdValueByCustomFieldSlug('addon_composer_name', $addon->id);
                        $is_installed = !is_null($this->addon->isAddonInstalled($composerName, $site_id));
                        $addon->is_installed = $is_installed;
                    }

                    return $addons;

                }
            )
        ];
    }
}
