$(document).on('ajaxComplete ready', function () {

    let element = $('#storename');

    $('input[data-provides="anomaly.field_type.slug"]:not([data-initialized])').each(function () {

        $(this).attr('data-initialized', '');

        var config = {
            slug: this,
            lowercase: $(this).data('lowercase')
        };

        /**
         * Only slugify other fields if
         * value is empty OR configured
         * to always slugify field values.
         */
        if (!$(this).val() || $(this).data('always_slugify')) {
            config.slugify = '[data-field="' + $(this).data('slugify') + '"]:visible:first';
        }

        // Slugify slug inputs.
        $(this).slugify(config);
    });

    element.on('change keyup', function () {
        let value = (element.val() === '') ? 'example' : element.val();
        $('.preview-domain').text(value);
    });

});

function selectBundle(id) {
    $('input[name="bundle_id"]').val(id);
    var currentBundle = $('.bundle[id="' + id + '"]');
    var currentBundleCircle = currentBundle.find('.input-circle');
    $('.input-circle.bundle-circle').removeClass('active');

    if (!currentBundleCircle.hasClass('active')) {
        $(currentBundleCircle).addClass('active');
    }
}

function selectLanguage(locale) {

    $('input[name="lang"]').val(locale);
    var currentLang = $('.locale[id="' + locale + '"]');
    var currentLangCircle = currentLang.find('.input-circle');

    $('.input-circle.lang-circle').removeClass('active');
    if (!currentLangCircle.hasClass('active')) {
        $(currentLangCircle).addClass('active');
    }
}

$('.site-create-form').on('submit', function () {
    $('.create-site-button').addClass('disabled').attr('disabled', true);
});
