const checkFav = (id, type, divId) => {
    $.ajax({
        type: 'get',
        url: '/favs/check_favorites/' + id + "/" + type,
        success: function (response) {
            if (response.length === 0) {
                $(divId).addClass("add-fav");
                $(divId + ' i').attr("class", "far fa-heart");
            } else {
                $(divId).removeClass("add-fav");
                $(divId + ' i').attr("class", "fas fa-heart");
            }
        }
    })
}

$(() => {
    ads.forEach((value) => {
        checkFav(value, 'adv', '#' + value)
    })
})

function saveFav(id, type) {
    crudAjax({'type': type, 'id': id}, '/favs/add_fav', 'POST', function (callback) {
        $('#' + id).removeClass("add-fav");
        $('#' + id + ' i.far').removeClass("far").addClass("fas");
    })
}

function deleteFav(id, type) {
    crudAjax({'type': type, 'id': id}, '/favs/delete_fav', 'POST', function (callback) {
        console.log(callback)
        if (callback.success) {
            $('#' + id).addClass("add-fav");
            $('#' + id + ' i.fas').removeClass("fas").addClass("far");
        }
    })
}

$('a.add-fav').on('click', function () {
    if ($(this).hasClass('add-fav')) {
        saveFav($(this).attr('id'), $(this).attr('data-type'))
    } else {
        deleteFav($(this).attr('id'), $(this).attr('data-type'))
    }
});