$('.selectpickers .list li').on('click', function () {
    let url = new URL(window.location.href);
    let sort_by = url.searchParams.get('sort_by');
    if (url.href.slice(-1) === "#") {
        url = new URL(url.href.slice(0, -1));
    }
    let page = url.searchParams.get('page');
    if (page){
        url.searchParams.delete('page');
    }
    var goURL = "";
    var value = $(this).attr('data-value');
    if (url.search === "") {
        goURL = url.href + "?sort_by=" + value;
    } else if (url.searchParams.has('sort_by')) {
        var parameters = "";
        if (value !== 'all') {
            parameters = "sort_by=" + value;
        }
        goURL = url.href.replace("sort_by=" + sort_by, parameters);
    } else {
        goURL = url + "&sort_by=" + value;
    }
    window.location.replace(goURL);
});

$(() => {
    let searchParams = new URLSearchParams(window.location.search);

    var sort_by = searchParams.get('sort_by');

    if (sort_by != null) {
        let selected = $('.selectpickers .list li[data-value=' + sort_by +']')
        $('.selectpickers .list li').removeClass('selected')
        selected.addClass('selected')
        $('.selectpickers .current').html(selected.html());
    }
});

// Change view type
function changeViewType(viewLink) {
    window.location.href = viewLink
}

function clearSearch() {
  $(".search-input").first().val("");
  
  const urlParams = new URLSearchParams(window.location.search);
  urlParams.delete("keyword");
  window.location.replace(
    window.location.pathname + "?" + urlParams.toString()
  );
}