<?php namespace Visiosoft\OcTheme;

use Anomaly\BlocksModule\Area\AreaRepository;
use Anomaly\PagesModule\Page\Contract\PageRepositoryInterface;
use Anomaly\PagesModule\Type\Contract\TypeRepositoryInterface;
use Anomaly\BlocksModule\Type\TypeRepository as BlockTypeRepository;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterDemoFeaturesRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterFeaturesRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterIntegrationsRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterNavbarBannerRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterPluginRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterPortfolioRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterShopRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterSliderDemosRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterTestimonialRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterUtilityRepeaterEntryModel;
use Anomaly\Streams\Platform\Model\Repeater\RepeaterWhyOcRepeaterEntryModel;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;
use Anomaly\UsersModule\User\UserModel;
use Visiosoft\CatsModule\Category\CategoryModel;
use Visiosoft\CustomfieldsModule\Cfvalue\Contract\CfvalueRepositoryInterface;
use Visiosoft\CustomfieldsModule\CustomField\Contract\CustomFieldRepositoryInterface;

class OcThemeSeeder extends Seeder
{
    protected $pages;
    protected $types;
    protected $fields;
    protected $assignments;
    protected $streamRepository;
    protected $customFieldRepository;
    protected $cfvalueRepository;
    protected $areaRepository;
    protected $blockTypes;

    public function __construct(
        PageRepositoryInterface $pages,
        TypeRepositoryInterface $types,
        BlockTypeRepository $blockTypes,
        FieldRepositoryInterface $fields,
        AssignmentRepositoryInterface $assignments,
        StreamRepositoryInterface $streamRepository,
        CustomFieldRepositoryInterface $customFieldRepository,
        CfvalueRepositoryInterface $cfvalueRepository,
        AreaRepository $areaRepository
    )
    {
        $this->pages = $pages;
        $this->types = $types;
        $this->blockTypes = $blockTypes;
        $this->fields = $fields;
        $this->assignments = $assignments;
        $this->streamRepository = $streamRepository;
        $this->customFieldRepository = $customFieldRepository;
        $this->cfvalueRepository = $cfvalueRepository;
        $this->areaRepository = $areaRepository;
    }

    /**
     * Run the seeder.
     */
    public function run()
    {
        ###Repeater Seeder
        $repeaters = [
            'navbar_banner_repeater' => [
                'content' => [
                    'name' => 'Navbar Banner Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'navbar_banner_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'file', 'color1', 'color2',
                ]
            ],
            'why_oc_repeater' => [
                'content' => [
                    'name' => 'Why OC Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'why_oc_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'file', 'title', 'description', 'attr'
                ]
            ],
            'demo_features_repeater' => [
                'content' => [
                    'name' => 'Demo Features Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'demo_features_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'icon', 'file', 'title', 'description', 'attr'
                ]
            ],
            'utility_repeater' => [
                'content' => [
                    'name' => 'Utility Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'utility_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'file',
                ]
            ],
            'slider_demos_repeater' => [
                'content' => [
                    'name' => 'Slider Demos Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'slider_demos_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'files'
                ]
            ],
            'plugin_repeater' => [
                'content' => [
                    'name' => 'Plugin Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'plugin_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'file', 'icon', 'title', 'plugin_options', 'attr'
                ]
            ],
            'shop_repeater' => [
                'content' => [
                    'name' => 'Shop Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'shop_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'file'
                ]
            ],
            'portfolio_repeater' => [
                'content' => [
                    'name' => 'Portfolio Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'portfolio_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => [
                    'files'
                ]
            ],
            'features_repeater' => [
                'content' => [
                    'name' => 'Features Area Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'features_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => ['file', 'title', 'description', 'attr']
            ],
            'testimonial_repeater' => [
                'content' => [
                    'name' => 'Testimonial Area Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'testimonial_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => ['title', 'description', 'user', 'star']
            ],
            'integrations_repeater' => [
                'content' => [
                    'name' => 'Integrations Repeater',
                    'namespace' => 'repeater',
                    'slug' => 'integrations_repeater',
                    'prefix' => 'repeater_',
                    'translatable' => true,
                ],
                'fields' => ['category', 'file', 'title', 'description']
            ]
        ];

        foreach ($repeaters as $slug => $item) {
            // Create New Repeaters
            if (!$repeater = $this->streamRepository->findBySlugAndNamespace($slug, 'repeater')) {
                $repeater = $this->streamRepository->create($item['content']);
            }

            //Fields Create and Assignment
            $fields_repeater = [
                'file' => [
                    'field_attributes' => [
                        'name' => 'File',
                        'namespace' => 'repeater',
                        'slug' => 'file',
                        'type' => 'anomaly.field_type.file',
                        'locked' => 0,
                        "config" => [
                            "folders" => ['images'],
                            "mode" => 'upload',
                        ],
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => true,
                    ]
                ],
                'files' => [
                    'field_attributes' => [
                        'name' => 'Files',
                        'namespace' => 'repeater',
                        'slug' => 'files',
                        'type' => 'anomaly.field_type.files',
                        'locked' => 0,
                        "config" => [
                            "folders" => ['images'],
                            "mode" => 'upload',
                        ],
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false,
                    ]
                ],
                'icon' => [
                    'field_attributes' => [
                        'name' => 'Icon',
                        'namespace' => 'repeater',
                        'slug' => 'icon',
                        'type' => 'anomaly.field_type.file',
                        'locked' => 0,
                        'config' => [
                            'folders' => ['images'],
                            'mode' => 'upload',
                        ]
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false,
                    ]
                ],
                'title' => [
                    'field_attributes' => [
                        'name' => 'Title',
                        'namespace' => 'repeater',
                        'slug' => 'title',
                        'type' => 'anomaly.field_type.text',
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ],
                'description' => [
                    'field_attributes' => [
                        'name' => 'Description',
                        'namespace' => 'repeater',
                        'slug' => 'description',
                        'type' => 'anomaly.field_type.textarea',
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                        'translatable' => true,
                    ]
                ],
                'attr' => [
                    'field_attributes' => [
                        'name' => 'Attr',
                        'namespace' => 'repeater',
                        'slug' => 'attr',
                        'type' => 'anomaly.field_type.text',
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false,
                    ]
                ],
                'demo_select' => [
                    'field_attributes' => [
                        'name' => 'Demo Select Field',
                        'namespace' => 'repeater',
                        'slug' => 'demo_select',
                        'type' => 'anomaly.field_type.select',
                        'config' => [
                            'options' => 'theme:Theme
											module:Module',
                            'mode' => 'radio'
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => true,
                    ]
                ],
                'is_new' => [
                    'field_attributes' => [
                        'name' => 'Is New',
                        'namespace' => 'repeater',
                        'slug' => 'is_new',
                        'type' => 'anomaly.field_type.checkboxes',
                        'config' => [
                            'options' => 'new:New',
                        ],
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false,
                    ]
                ],
                'plugin_options' => [
                    'field_attributes' => [
                        'name' => 'Plugin Options',
                        'namespace' => 'repeater',
                        'slug' => 'plugin_options',
                        'type' => 'anomaly.field_type.select',
                        'locked' => 0,
                        'config' => [
                            'options' => 'premium_plugin:Premium Plugin
											required_plugin:Required Plugin',
                        ]
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => true,
                    ]
                ],
                'star' => [
                    'field_attributes' => [
                        'name' => 'Star',
                        'namespace' => 'repeater',
                        'slug' => 'star',
                        'type' => 'anomaly.field_type.integer',
                        'locked' => 0,
                        'config' => [
                            'max' => 5,
                        ],
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false,
                    ]
                ],
                'user' => [
                    'field_attributes' => [
                        'name' => 'User',
                        'namespace' => 'repeater',
                        'slug' => 'user',
                        'type' => 'anomaly.field_type.relationship',
                        'locked' => 0,
                        'config' => [
                            'related' => UserModel::class,
                        ]
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false,
                    ]
                ],
                'category' => [
                    'field_attributes' => [
                        'name' => 'Category',
                        'namespace' => 'repeater',
                        'slug' => 'category',
                        'type' => 'anomaly.field_type.relationship',
                        'locked' => 0,
                        'config' => [
                            'related' => CategoryModel::class,
                        ],
                    ],
                    'assignment_attributes' => [
                        'required' => false,
                        'translatable' => false,
                    ]
                ],
                'color1' => [
                    'field_attributes' => [
                        'name' => 'Color 1',
                        'namespace' => 'repeater',
                        'slug' => 'color1',
                        'type' => 'anomaly.field_type.colorpicker',
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                    ]
                ],
                'color2' => [
                    'field_attributes' => [
                        'name' => 'Color 2',
                        'namespace' => 'repeater',
                        'slug' => 'color2',
                        'type' => 'anomaly.field_type.colorpicker',
                        'locked' => 0,
                    ],
                    'assignment_attributes' => [
                        'required' => true,
                    ]
                ]
            ];

            foreach ($fields_repeater as $field_slug => $field_repeater) {
                if (!$field = $this->fields->findBySlugAndNamespace($field_slug, 'repeater')) {
                    $field = $this->fields->create($field_repeater['field_attributes']);
                }

                if (in_array($field->getSlug(), $item['fields'])) {
                    if (!$this->assignments->findByStreamAndField($repeater, $field)) {
                        // File Field Assignment
                        $this->assignments->create(
                            array_merge([
                                'stream' => $repeater,
                                'field' => $field,
                            ], $field_repeater['assignment_attributes'])
                        );
                    }
                }
            }
        }

        ### Page Seeder
        $fields = [
            'why_oc_repeater_fields' => [
                'name' => 'Why OC RFP',
                'namespace' => 'pages',
                'slug' => 'why_oc_repeater_fields',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterWhyOcRepeaterEntryModel::class,
                ],
            ],
            'home_repeater_fields' => [
                'name' => 'Home Repeater Fields',
                'namespace' => 'pages',
                'slug' => 'home_repeater_fields',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterNavbarBannerRepeaterEntryModel::class,
                ]
            ],
            'editor' => [
                'name' => 'Editor',
                'namespace' => 'pages',
                'slug' => 'editor',
                'type' => 'anomaly.field_type.editor',
                'locked' => 0
            ],
            'landing_id' => [
                'name' => 'Landing Id',
                'namespace' => 'pages',
                'slug' => 'landing_id',
                'type' => 'anomaly.field_type.text',
                'locked' => 0,
            ],
            'demo_features_repeater' => [
                'name' => 'Demo Features Repeater Fields',
                'namespace' => 'pages',
                'slug' => 'demo_features_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterDemoFeaturesRepeaterEntryModel::class,
                ]
            ],
            'utility_repeater' => [
                'name' => 'Utility Repeater Fields',
                'namespace' => 'pages',
                'slug' => 'utility_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterUtilityRepeaterEntryModel::class,
                ]
            ],
            'slider_demos_repeater' => [
                'name' => 'Slider Demos Repeater',
                'namespace' => 'pages',
                'slug' => 'slider_demos_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterSliderDemosRepeaterEntryModel::class,
                ]
            ],
            'plugin_repeater' => [
                'name' => 'Plugin Repeater',
                'namespace' => 'pages',
                'slug' => 'plugin_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterPluginRepeaterEntryModel::class,
                ]
            ],
            'shop_repeater' => [
                'name' => 'Shop Repeater',
                'namespace' => 'pages',
                'slug' => 'shop_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => '0',
                'config' => [
                    'related' => RepeaterShopRepeaterEntryModel::class,
                ]
            ],
            'portfolio_repeater' => [
                'name' => 'Portfolio Repeater',
                'namespace' => 'pages',
                'slug' => 'portfolio_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterPortfolioRepeaterEntryModel::class,
                ]
            ],
            'features_repeater' => [
                'name' => 'Features Repeater',
                'namespace' => 'pages',
                'slug' => 'features_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterFeaturesRepeaterEntryModel::class,
                ]
            ],
            'testimonial_repeater' => [
                'name' => 'Testimonial Repeater',
                'namespace' => 'pages',
                'slug' => 'testimonial_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterTestimonialRepeaterEntryModel::class,
                ]
            ],
            'integration_repeater' => [
                'name' => 'Integration Repeater',
                'namespace' => 'pages',
                'slug' => 'integration_repeater',
                'type' => 'anomaly.field_type.repeater',
                'locked' => 0,
                'config' => [
                    'related' => RepeaterIntegrationsRepeaterEntryModel::class,
                ]
            ],
        ];

        $types = [
            'editor' => [
                'content' => [
                    'en' => [
                        'name' => 'Editor',
                        'description' => 'An editor type for home page',
                    ],
                    'slug' => 'editor',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layouts/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => [
                    'editor'
                ],
            ],
            'home' => [
                'content' => [
                    'en' => [
                        'name' => 'Home Type',
                        'description' => 'This type for home page',
                    ],
                    'slug' => 'home',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layouts/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => [
                    'editor', 'home_repeater_fields'
                ]
            ],
            'why_oc' => [
                'content' => [
                    'en' => [
                        'name' => 'Why OC',
                        'description' => 'This Type For Why Oc Area in Home Page'
                    ],
                    'slug' => 'why_oc',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layouts/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'why_oc_repeater_fields']
            ],
            'demos_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Demos',
                        'description' => 'This Type For Demos Area in Home Page'
                    ],
                    'slug' => 'demos_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layouts/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor']
            ],
            'demo_features_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Demo Features',
                        'description' => 'This Type For Demo Features Area in Home Page',
                    ],
                    'slug' => 'demo_features_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'demo_features_repeater']
            ],
            'utility_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Utility Area',
                        'description' => 'This Type For Utility Area in Home Page',
                    ],
                    'slug' => 'utility_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'utility_repeater']
            ],
            'slider_demos_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Slider Demos Area',
                        'description' => 'This Type For Slider Demos Area in Home Page',
                    ],
                    'slug' => 'slider_demos_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'slider_demos_repeater']
            ],
            'plugin_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Plugin Area',
                        'description' => 'This Type For Plugin Area in Home Page',
                    ],
                    'slug' => 'plugin_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'plugin_repeater']
            ],
            'shop_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Shop Area',
                        'description' => 'This Type For Shop Area in Home Page'
                    ],
                    'slug' => 'shop_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'shop_repeater']
            ],
            'portfolio_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Portfolio Area',
                        'description' => 'This Type For Portfolio Area in Home Page',
                    ],
                    'slug' => 'portfolio_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'portfolio_repeater']
            ],
            'features_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Features Area',
                        'description' => 'This Type For Features Area in Home Page',
                    ],
                    'slug' => 'features_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'features_repeater']
            ],
            'testimonial_area' => [
                'content' => [
                    'en' => [
                        'name' => 'Testimonial Area',
                        'description' => 'This Type For Testimonial Area in Home Page',
                    ],
                    'slug' => 'testimonial_area',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'testimonial_repeater']
            ],
            'contact_type' => [
                'content' => [
                    'en' => [
                        'name' => 'Contact Us',
                        'description' => 'This Type For Contact Page',
                    ],
                    'slug' => 'contact_type',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{% block content %}
                                    {{ page.editor|raw }}
                                        <script src="https://maps.googleapis.com/maps/api/js?key={{ setting_value('visiosoft.module.location::google_map_key') }}"></script>
	                                    {{ asset_script("theme::js/gmaps.min.js") }}
                                {% endblock %}',
                ],
                'fields' => ['content', 'editor'],
            ],
            'page_type' => [
                'content' => [
                    'en' => [
                        'name' => 'Page Type',
                        'description' => 'This Type For Anyone Page'
                    ],
                    'slug' => 'page_type',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layout/default.twig',
                    'layout' => '{{ page.editor|raw }}'
                ],
                'fields' => ['content', 'editor'],
            ],
            'landing_type' => [
                'content' => [
                    'en' => [
                        'name' => 'Landing Type',
                        'description' => 'This Type For Landing Page',
                    ],
                    'slug' => 'landing_type',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layouts/landing.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['landing_id', 'editor']
            ],
            'integration_type' => [
                'content' => [
                    'en' => [
                        'name' => 'Integration Type',
                    ],
                    'slug' => 'integration_type',
                    'handler' => 'anomaly.extension.default_page_handler',
                    'theme_layout' => 'theme::layouts/integrations.twig',
                    'layout' => '{{ page.editor|raw }}',
                ],
                'fields' => ['editor', 'integration_repeater']
            ],
        ];

        $pages = [
            'home' => [
                'content' => [
                    'en' => [
                        'title' => 'Home',
                    ],
                    'slug' => 'home',
                    'enabled' => 'true',
                    'home' => true,
                    'theme_layout' => 'theme::layouts/default.twig',
                ],
                'entry_content' => [
                    'en' => [
                        'editor' => '',
                    ]
                ],
                'type' => 'home',

                'children' => [
                    'why_oc' => [
                        'content' => [
                            'en' => [
                                'title' => 'Why OC',
                            ],
                            'slug' => 'why_oc',
                            'enabled' => 'true',
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' =>
                                    '<section class="demo_features_area sec_pad" id="fe">
										<div class="container custom_container_two">
											<div class="section_title text-center wow fadeInUp" data-wow-delay="0.2s">
												<h2>{{ trans(\'theme::pages.why_oc.title\')|raw }}</h2>
											</div>
											<div class="row">
												{% for whyOc in page(pagesFindBySlug(\'why-oc\')).entry.why_oc_repeater_fields %}
													<div class="col-lg-4 col-md-6 px-lg-5" {{ whyOc.attr|raw }}>
														<div class="features_item wow fadeInLeft">
															{{ img(file(whyOc.getAttribute(\'file\')).make.url) }}
															<div class="content">
																<h3>{{ whyOc.title|raw }}</h3>
																<p>{{ whyOc.description|raw }}</p>
															</div>
														</div>
													</div>
												{% endfor %}
											</div>
										</div>
									</section>',
                            ],
                        ],
                        'type' => 'why_oc',
                    ],
                    'demos' => [
                        'content' => [
                            'en' => [
                                'title' => 'Demos'
                            ],
                            'slug' => 'demos',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '{% set advs = entries(\'advs\').findAdsByCategoryId(setting_value(\'visiosoft.theme.oc::category_for_theme\')) %}
												{% set all_count = entries(\'advs\').findAdsByCategoryId(setting_value(\'visiosoft.theme.oc::category_for_theme\')).count() %}
												{% set subCats = entries(\'cats\',\'category\').where(\'parent_category_id\', setting_value(\'visiosoft.theme.oc::category_for_theme\')).get() %}
												<section class="demo_area sec_pad bg_color" id="demo">
													<div class="bg_demo"></div>
													<div class="container custom_container_two">
														<div class="row">
															<div class="col-12">
																<div class="section_title text-center">
																	<div class="number wow fadeInUp" data-wow-delay="200ms">31<sup>+</sup></div>
																	<h2 class=" wow fadeInUp" data-wow-delay="400ms">{{ trans(\'theme::pages.demos.title\')|raw }}</h2>
																	<p>{{ trans(\'theme::pages.demos.description\')|raw }}</p>
																</div>
															</div>
														</div>
														<div class="row">
															<div class="col-12">
																<nav class="filtering_demos wow fadeInUp" data-wow-delay="500ms">
																	<div class="nav nav-tabs" id="nav-tab">
																		<a class="nav-item nav-link active" data-toggle="tab" href="#all_page">All
																			<span>{{ all_count }}</span></a>
																		{% for subCat in subCats %}
																			<a class="nav-item nav-link" data-toggle="tab" href="#{{ subCat.slug }}">
																				{{ subCat.name }} <span>{{ entries(\'advs\').findAdsByCategoryId(subCat.id, 2).count() }}</span>
																			</a>
																		{% endfor %}
																	</div>
																</nav>
															</div>
														</div>
														<div class="tab-content" id="nav-tabContent">
															<div class="tab-pane fade show active" id="all_page">
																<div class="row">
																	{% for theme in advs|slice(0, 6) %}
																		<div class="col-lg-4 col-sm-6 col-12 portfolio-item nav-home">
																			<div class="portfolio-image">
																				<div class="img">
																					<a href="{{ theme.detail_url }}">{{ img(theme.cover_photo) }}</a>
																					{% if theme.is_new.value[0] == \'new\' %}
																						<span class="new">New</span>
																					{% endif %}
																				</div>
																				<a href="{{ theme.detail_url }}"><h6>{{ theme.name }}</h6></a>
																			</div>
																		</div>
																	{% endfor %}
																</div>
															</div>
															{% for subCat in subCats %}
																<div class="tab-pane fade" id="{{ subCat.slug }}">
																	<div class="row">
																		{% for theme in entries(\'advs\').findAdsByCategoryId(subCat.id, 2) %}
																			<div class="col-lg-4 col-sm-6 col-12 portfolio-item nav-home">
																				<div class="portfolio-image">
																					<div class="img">
																						{{ img(theme.cover_photo) }}
																						{% if theme.is_new.value[0] == \'new\' %}
																							<span class="new">New</span>
																						{% endif %}
																					</div>
																					<a href="{{ theme.detail_url }}"><h6>{{ theme.name }}</h6></a>
																				</div>
																			</div>
																		{% endfor %}
																	</div>
																</div>
															{% endfor %}
														</div>
													</div>
																							<div class="d-flex justify-content-center mt-5 pt-5">
											<a href="c/themes" class="slider_btn btn_hover bg-dark text-white d-flex align-items-center">
												<img src="{{ img(\'theme::images/plus.svg\').url }}" alt="" width="12" />
												<span class="ml-2">
													{{ trans(\'theme::field.show_all_themes\')|raw }}
												</span>
											</a>
										</div>
									</section>'
                            ],
                        ],
                        'type' => 'demos_area'
                    ],
                    'demo_features' => [
                        'content' => [
                            'en' => [
                                'title' => 'Demo Features',
                            ],
                            'slug' => 'demo_features',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '<section class="demo_feature_area">
									<img class="f_shap f_shap_one" src="{{ img(\'theme::images/demo/f_shap.png\').url }}" alt="">
									<img class="f_shap f_shap_two" src="{{ img(\'theme::images/demo/f_shap_two.png\').url }}" alt="">
									<div class="container custom_container">
										{% for demo_feature in page(pagesFindBySlug(\'demo-features\')).entry.demo_features_repeater %}
											<div class="row align-items-center {{ demo_feature.attr|raw }}">
												<div class="col-lg-6">
													<div class="f_img wow fadeInRight" data-wow-delay="0.2s">
														{{ img(file(demo_feature.getAttribute(\'file\')).make.url) }}
													</div>
												</div>
												<div class="col-lg-6">
													<div class="f_content">
														<div class="g_logo wow fadeInUp">
															{{ img(file(demo_feature.getAttribute(\'icon_id\')).make.url) }}
														</div>
														<h2 class="wow fadeInUp">{{ demo_feature.title|raw }}</h2>
														<p class="wow fadeInUp" data-wow-delay="0.2s">{{ demo_feature.description|raw }}</p>
													</div>
												</div>
											</div>
										{% endfor %}
									</div>
								</section>'
                            ]
                        ],
                        'type' => 'demo_features_area'
                    ],
                    'utility' => [
                        'content' => [
                            'en' => [
                                'title' => 'Utility',
                            ],
                            'slug' => 'utility',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '{% set page = page(pagesFindBySlug(\'utility\')) %}
									<section class="utility_area align-items-center">
										<img class="u_round" src="{{ img(\'theme::images/demo/round.png\').url }}" alt="">
										<div class="utility_right">
											<div class="utility_slider">
												{% for images in page.entry.utility_repeater %}
													<div class="item">
														{{ img(file(images.getAttribute(\'file\')).make.url) }}
													</div>
												{% endfor %}
											</div>
										</div>
										<div class="utility_left">
											<div class="u_content">
												<h2>{{ trans(\'theme::pages.utility.title\')|raw }} </h2>
												<p>{{ trans(\'theme::pages.utility.description\')|raw }}</p>
												<a href="#demo" class="f_btn scrolls">{{ trans(\'theme::pages.utility.button\')|raw }}</a>
											</div>
										</div>
									</section>'
                            ]
                        ],
                        'type' => 'utility_area'
                    ],
                    'slider_demos' => [
                        'content' => [
                            'en' => [
                                'title' => 'Slider Demos',
                            ],
                            'slug' => 'slider_demos',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '<section class="slider_demos_area" id="Element_Blocks">
												<div class="container">
													<div class="section_title text-center">
														<div class="number wow fadeInUp" data-wow-delay="200ms">250<sup>+</sup></div>
														<h2 class="wow fadeInUp" data-wow-delay="400ms">{{ trans(\'theme::pages.slider_demos.title\')|raw }} </h2>
														<p class="wow fadeInUp" data-wow-delay="600ms">{{ trans(\'theme::pages.slider_demos.description\')|raw }}</p>
													</div>
												</div>
												<div class="slick marquee">
													{% for images in page(pagesFindBySlug(\'slider-demos\')).entry.slider_demos_repeater %}
														<div class="slick-slide">
															<a href="#">
																<div class="inner">
																	{% for image in images.files %}
																		{{ img(image.make.url) }}
																	{% endfor %}
																</div>
															</a>
														</div>
													{% endfor %}
												</div>
											</section>',
                            ],
                        ],
                        'type' => 'slider_demos_area',
                    ],
                    'plugin' => [
                        'content' => [
                            'en' => [
                                'title' => 'Plugin',
                            ],
                            'slug' => 'plugin',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '{% set plugins = page(pagesFindBySlug(\'plugin\')).entry.plugin_repeater %}
									<section class="plugin_area" id="elements">
										<div class="container">
											<h6>{{ trans(\'theme::pages.plugin.title\')|raw }}</h6>
											<h2 class="wow fadeInUp" data-wow-delay="400ms">{{ trans(\'theme::pages.plugin.main_title\')|raw }} </h2>
											<h4 class="text-center plugin_sub_title">{{ trans(\'theme::pages.plugin.premium_sub_title\')|raw }}</h4>
											<div class="row justify-content-center">
												{% for plugin in plugins.where(\'plugin_options\', \'premium_plugin\') %}
													<div class="col-lg-3 col-md-4 col-sm-4 wow fadeInUp" {{ plugin.attr|raw }}>
														<div class="plugin_item">
															<div class="img">
																<img class="save wow zoomIn" data-wow-delay="1s"
																     src="{{ img(plugin.icon.make.url).url }}" alt="">
																<img src="{{ img(plugin.file.make.url).url }}" alt="">
															</div>
															<h4>{{ plugin.title|raw }}</h4>
															<p class="orange">{{ plugin.plugin_options|raw }}</p>
														</div>
													</div>
												{% endfor %}
											</div>
											<h4 class="text-center plugin_sub_title">{{ trans(\'theme::pages.plugin.other_sub_title\')|raw }}</h4>
											<div class="row">
												{% for plugin in plugins.whereNotIn(\'plugin_options\', [\'premium_plugin\']) %}
													<div class="col-lg-3 col-md-4 col-sm-4 wow fadeInUp" {{ plugin.attr|raw }}>
														<div class="plugin_item">
															<div class="img">
																<img class="save wow zoomIn" data-wow-delay="1s"
																     src="{{ img(plugin.icon.make.url).url }}" alt="">
																<img src="{{ img(plugin.file.make.url).url }}" alt="">
															</div>
															<h4>{{ plugin.title|raw }}</h4>
															<p>{{ plugin.plugin_options|raw }}</p>
														</div>
													</div>
												{% endfor %}
											</div>
										</div>
									</section>',
                            ]
                        ],
                        'type' => 'plugin_area'
                    ],
                    'shop' => [
                        'content' => [
                            'en' => [
                                'title' => 'Shop',
                            ],
                            'slug' => 'shop',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '<section class="shop_area" id="shop">
									<div class="container">
										<div class="row align-items-center">
											<div class="col-lg-6">
												<div class="shop_slider">
                                                    {% for images in page(pagesFindBySlug(\'shop\')).entry.shop_repeater %}
															<div class="item">{{ img(file(images.getAttribute(\'file\')).make.url) }}</div>
													{% endfor %}
                                                </div>
											</div>
											<div class="col-lg-6">
												<div class="u_content">
													<h3 class="wow fadeInUp">{{ trans(\'theme::pages.shop.title\')|raw }}</h3>
													<h2 class="wow fadeInUp" data-wow-delay="0.1s">{{ trans(\'theme::pages.shop.main_title\')|raw }}</h2>
													<p class="wow fadeInUp" data-wow-delay="0.2s">{{ trans(\'theme::pages.shop.description\')|raw }}</p>
													{{ trans(\'theme::pages.shop.list\')|raw }}
												</div>
											</div>
										</div>
									</div>
								</section>'
                            ]
                        ],
                        'type' => 'shop_area'
                    ],
                    'responsive_area' => [
                        'content' => [
                            'en' => [
                                'title' => 'Responsive Area',
                            ],
                            'slug' => 'responsive_area',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '<section class="responsive_area">
												<div class="container custom_container">
													<div class="row">
														<div class="col-lg-8">
															<div class="responsive_device">
																<img class="wow fadeInUp" data-wow-delay="0.2s"
																	 src="{{ img(\'theme::images/demo/iPhone-8.png\').url }}" alt="">
																<img class="wow fadeInUp" data-wow-delay="0.4s"
																	 src="{{ img(\'theme::images/demo/iPhone-8-Plus.png\').url }}" alt="">
																<img class="wow fadeInUp" data-wow-delay="0.6s" src="{{ img(\'theme::images/demo/iPad.png\').url }}"
																	 alt="">
																<img class="wow fadeInUp" data-wow-delay="0.8s"
																	 src="{{ img(\'theme::images/demo/iPhone-X.png\').url }}" alt="">
															</div>
														</div>
														<div class="col-lg-4">
															<div class="responsive_content">
																<div class="u_content">
																	<h3>{{ trans(\'theme::pages.responsive_area.title\')|raw }}</h3>
																	<h2>{{ trans(\'theme::pages.responsive_area.main_title\')|raw }} </h2>
																	<div class="row">
																		<div class="col-lg-6 col-md-6 wow fadeInLeft" data-wow-delay="0.2s">
																			<div class="item">
																				<img src="{{ img(\'theme::images/demo/responsive.svg\').url }}" alt="">
																				<h5>{{ trans(\'theme::pages.responsive_area.responsive_title\')|raw }}</h5>
																				<p>{{ trans(\'theme::pages.responsive_area.responsive_description\')|raw }}</p>
																			</div>
																		</div>
																		<div class="col-lg-6 col-md-6 wow fadeInLeft" data-wow-delay="0.4s">
																			<div class="item">
																				<img src="{{ img(\'theme::images/demo/retina.svg\').url }}" alt="">
																				<h5>{{ trans(\'theme::pages.responsive_area.retina_title\')|raw }}</h5>
																				<p>{{ trans(\'theme::pages.responsive_area.retina_description\')|raw }}</p>
																			</div>
																		</div>
																	</div>
																</div>
															</div>
														</div>
													</div>
												</div>
											</section>'
                            ]
                        ],
                        'type' => 'editor',
                    ],
                    'portfolio' => [
                        'content' => [
                            'en' => [
                                'title' => 'Portfolio'
                            ],
                            'slug' => 'portfolio',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '<section class="portfolio_area portfolio_padding">
									<div class="container">
										<div class="section_title text-center">
											<h2 class=" wow fadeInUp" data-wow-delay="400ms">{{ trans(\'theme::pages.portfolio.title\')|raw }} </h2>
											<p class=" wow fadeInUp" data-wow-delay="500ms"> {{ trans(\'theme::pages.portfolio.description\')|raw }}</p>
										</div>
									</div>
									<div class="p_slider_inner">
										<div class="portfolio_slider">
											{% for images in page(pagesFindBySlug(\'portfolio\')).entry.portfolio_repeater %}
												{% for image in images.files %}
													<div class="item">
														<div class="p_item">{{ img(image.make.url) }}</div>
													</div>
												{% endfor %}
											{% endfor %}
										</div>
										<div class="arrow">
											<i class="ti-arrow-left prevs"></i>
											<i class="ti-arrow-right nexts"></i>
										</div>
									</div>
								</section>'
                            ],
                        ],
                        'type' => 'portfolio_area'
                    ],
                    'features' => [
                        'content' => [
                            'en' => [
                                'title' => 'Features',
                            ],
                            'slug' => 'features',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '<section class="c_features_area_two" id="features">
									<div class="container custom_container">
										<div class="section_title text-center">
											<h2 class=" wow fadeInUp" data-wow-delay="400ms">{{ trans(\'theme::pages.features.title\')|raw }}</h2>
										</div>
										<div class="row">
											{% for item in page(pagesFindBySlug(\'features\')).entry.features_repeater %}
											<div class="col-lg-3 col-sm-6 wow fadeInUp" {{ item.attr }}>
												<div class="c_features_item">
													{{ img(file(item.getAttribute(\'file\')).make.url) }}
													<h4>{{ item.title|raw }}</h4>
													<p>{{ item.description|raw }}</p>
												</div>
											</div>
											{% endfor %}
										</div>
									</div>
								</section>'
                            ],
                        ],
                        'type' => 'features_area',
                    ],
                    'testimonial' => [
                        'content' => [
                            'en' => [
                                'title' => 'Testimonial',
                            ],
                            'slug' => 'testimonial',
                            'enabled' => true,
                            'home' => false,
                            'theme_layout' => 'theme::layouts/default.twig',
                        ],
                        'entry_content' => [
                            'en' => [
                                'editor' => '<section class="testimonial_area">
									<div class="container">
										<div class="section_title text-center">
											<h2 class=" wow fadeInUp" data-wow-delay="400ms"><span>Real Customer Feedback</span><br>Still not impressed?<br>
												Don’t take our words, check what our customers say.</h2>
										</div>
									</div>
									<div class="test_inner">
										<div class="testimonial_slider_demo" id="testimonial_demo_slider">
											{% for item in page(pagesFindBySlug(\'testimonial\')).entry.testimonial_repeater %}
												<div class="item">
													<div class="content">
														<div class="d-flex">
															<div class="text">
																<h5>{{ item.user.username }}</h5>
																<span>{{ item.title }}</span>
															</div>
															<div class="ratting">
															{% for star in 1..5 %}
																{% if star <= item.star.value %}
																	<i class="icon_star"></i>
																{% else %}
																	<i class="icon_star_alt"></i>
																{% endif %}
															{% endfor %}
															</div>
														</div>
														<p>{{ item.description }}</p>
													</div>
												</div>
											{% endfor %}
										</div>
										<div class="arrow">
											<i class="ti-arrow-left tprevs"></i>
											<i class="ti-arrow-right tnexts"></i>
										</div>
									</div>
								</section>'
                            ]
                        ],
                        'type' => 'testimonial_area',
                    ]
                ]
            ],
            'contact-us' => [
                'content' => [
                    'en' => [
                        'title' => 'Contact Us',
                    ],
                    'slug' => 'contact-us',
                    'enabled' => 'true',
                    'home' => false,
                    'theme_layout' => 'theme::layouts/page.twig',
                ],
                'entry_content' => [
                    'en' => [
                        'editor' => '<section class="contact_info_area sec_pad bg_color">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 pr-0">
                        <div class="contact_info_item">
                            <h6 class="f_p f_size_20 t_color3 f_500 mb_20">{{ trans(\'theme::field.office_address\') }}</h6>
                            <p class="f_400 f_size_15">YTU Teknopark Çifte Havuzlar Mah. Eski Londra Asf. Cad. No:5 Başakşehir/İstanbul</p>
                        </div>
                        <div class="contact_info_item">
                            <h6 class="f_p f_size_20 t_color3 f_500 mb_20">{{ trans(\'theme::field.contact_info\') }}</h6>
                            <p class="f_400 f_size_15"><span class="f_400 t_color3">{{ trans(\'theme::field.phone\') }}:</span> <a href="tel:3024437488">(+096) 302 443 7488</a></p>
                            <p class="f_400 f_size_15"><span class="f_400 t_color3">{{ trans(\'theme::field.web\') }}:</span> <a href="https://www.openclassify.com">www.openclassify.com</a></p>
                            <p class="f_400 f_size_15"><span class="f_400 t_color3">{{ trans(\'theme::field.email\') }}:</span> <a href="mailto:saasland@gmail.com">saasland@gmail.com</a></p>
                        </div>
                    </div>
                    <div class="col-lg-8 offset-lg-1">
                        <div class="mapbox">
                            <div id="mapBox" class="row m0" data-lat="41.0239961" data-lon="28.8918522" data-zoom="15" data-info="YTU Teknopark Çifte Havuzlar Mah. Eski Londra Asf. Cad. No:5 Başakşehir/İstanbul" data-marker="{{ img(\'theme::images/map2.png\').url }}" data-mlat="41.0239961" data-mlon="28.8918522">
                            </div>
                        </div>
                    </div>
                </div>
                <div class="contact_form">
                    <h2 class="f_p f_size_22 t_color3 f_600 l_height28 mt_100 mb_40">{{ trans(\'theme::field.leave_message\') }}</h2>
					{% set form = form(\'contact\').to(setting_value(\'streams::email\', \'noreply@openclassify.com\')).from(\'{email}\').get() %}
					{{ form_open({ \'url\': form.options.url, \'class\': \'mt-auto\'})|raw }}
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="form-group text_box">
									{{ form.fields.name.setAttributes({
										\'required\' :true,
									}).setPlaceholder( trans(\'theme::field.your_name\') ).input|raw }}
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="form-group text_box">
									{{ form.fields.email.setAttributes({
										\'required\' :true,
										\'inputmode\' : \'email\'
									}).setPlaceholder( trans(\'theme::field.your_email\') ).input|raw }}
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group text_box">
									<input type="hidden" name="subject" value="3">
                                </div>
                            </div>
                            <div class="col-lg-12">
                                <div class="form-group text_box">
									{{ form.fields.message.setAttributes({
										\'required\' :true,
										\'rows\' :14,
									}).setPlaceholder( trans(\'theme::field.message\') ).input|raw }}
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn_three">{{ trans(\'theme::field.send_message\') }}</button>
                </div>
            </div>
        </section>',
                        'content' => '<p class="f_400 w_color f_size_16 l_height26">Ürünlerimize göz atmadan karar verme. Ocify.co, 50 yi aşkın ülkede aktif olarak kullanılan Modüler ve en gelişmiş açık kaynaklı ilan platformdur</p>'
                    ]
                ],
                'type' => 'contact_type',
                'children' => []
            ],
            'faq' => [
                'content' => [
                    'en' => [
                        'title' => 'FAQ',
                    ],
                    'slug' => 'faq',
                    'enabled' => 'true',
                    'home' => false,
                    'theme_layout' => 'theme::layouts/page.twig',
                ],
                'entry_content' => [
                    'en' => [
                        'content' => '<p class="f_400 w_color f_size_16 l_height26">Ürünlerimize göz atmadan karar verme. Ocify.co, 50 yi aşkın ülkede aktif olarak kullanılan Modüler ve en gelişmiş açık kaynaklı ilan platformdur</p>',
                        'editor' => ''
                    ]
                ],
                'type' => 'page_type',
                'children' => []
            ],
            'integrations' => [
                'content' => [
                    'en' => [
                        'title' => 'Integrations',
                    ],
                    'slug' => 'integrations',
                    'enabled' => 'true',
                    'home' => false,
                    'theme_layout' => 'theme::layouts/integrations.twig',
                ],
                'entry_content' => [
                    'en' => [
                        'editor' => '',
                    ]
                ],
                'type' => 'integration_type',
                'children' => []
            ]
        ];

        foreach ($fields as $slug => $item) {
            if (!$field = $this->fields->findBySlugAndNamespace($slug, 'pages')) {
                $field = $this->fields->create($item);
            }
        }

        foreach ($types as $type_slug => $type_content) {
            if (!$type = $this->types->findBySlug($type_slug)) {
                $type = $this->types->create($type_content['content']);
                $stream = $type->getEntryStream();
                foreach ($type_content['fields'] as $field) {
                    $this->assignments->create([
                        'stream' => $stream,
                        'field' => $this->fields->findBySlugAndNamespace($field, 'pages')
                    ]);
                }
            }
        }

        foreach ($pages as $page) {
            $type = $this->types->findBySlug($page['type']);
            $selected_type = [];
            foreach ($page['entry_content'] as $content) {
                $selected_type = [
                    'type' => $type,
                    'entry' => $type->getEntryModel()->newQuery()->create($content)
                ];
            }
            $new_page = array_merge($page['content'], $selected_type);
            $mainPage = $this->pages->create($new_page)->getQueueableId();

            if ($page['children']) {
                foreach ($page['children'] as $child) {
                    $type = $this->types->findBySlug($child['type']);
                    $selected_type = [];
                    foreach ($child['entry_content'] as $content) {
                        $selected_type = [
                            'type' => $type,
                            'entry' => $type->getEntryModel()->newQuery()->create($content),
                            'parent_id' => $mainPage,
                        ];
                    }
                    $new_page = array_merge($child['content'], $selected_type);
                    $this->pages->create($new_page);
                }
            }
        }

        $customfields = [
            [
                'field' => [
                    'slug' => 'is_large',
                    'type' => 'checkboxes',
                    'required' => false,
                    'en' => [
                        'name' => 'Is Large',
                    ],
                ],
                'value' => [
                    'en' => [
                        'custom_field_value' => 'Yes'
                    ]
                ]
            ], [
                'field' => [
                    'slug' => 'color',
                    'type' => 'text',
                    'required' => false,
                    'en' => [
                        'name' => 'Color',
                    ],
                ],
            ], [
                'field' => [
                    'slug' => 'addon_preview_link',
                    'type' => 'text',
                    'required' => false,
                    'en' => [
                        'name' => 'Addon Preview Link',
                    ],
                ],
                'value' => []
            ]
        ];

        foreach ($customfields as $customfield) {
            if (!$this->customFieldRepository->findBySlug($customfield['field']['slug'])) {
                $customfield = $this->customFieldRepository->create($customfield['field']);
                if (array_key_exists('value', $customfields)) {
                    $this->cfvalueRepository->create([
                        'custom_field_id' => $customfield->id,
                        'en' => [
                            'custom_field_value' => 'Yes'
                        ]
                    ]);
                }
            }
        }

        // For Blocks
        $areas = [
            [
                'en' => [
                    'name' => 'Ads For Gallery List',
                ],
                'slug' => 'ads-for-gallery-list',
            ],
        ];

        foreach ($areas as $area) {
            if (!$this->areaRepository->findBySlug($area['slug'])) {
                $this->areaRepository->create($area);
            }
        }

        $types = [
            [
                'name' => 'Ads For Gallery List',
                'slug' => 'ads_for_gallery_list',
            ],
        ];

        foreach ($types as $type) {
            $exist_type = $this->blockTypes->findBySlug($type['slug']);
            if (!$exist_type) {
                $this->blockTypes->create([
                    'slug' => $type['slug'],
                    'name' => $type['name'],
                    'category' => 'other'
                ]);
            }
        }

        $blockFields = [
            [
                'name' => 'Image',
                'slug' => 'image',
                'namespace' => 'blocks',
                'streams' => ['ads_for_gallery_list'],
                'type' => 'anomaly.field_type.file',
                'translatable' => true,
                'config' => [
                    'folders' => ['images'],
                    'mode' => 'upload',
                ],
            ], [
                'name' => 'URL',
                'slug' => 'url',
                'namespace' => 'blocks',
                'streams' => ['ads_for_gallery_list'],
                'type' => 'anomaly.field_type.url',
                'translatable' => false,
                'config' => [],
            ]
        ];


        foreach ($blockFields as $blockField) {
            $field = $this->fields->findBySlugAndNamespace($blockField['slug'], 'blocks');
            if (!$field) {
                $field = $this->fields->create([
                    'name' => $blockField['name'],
                    'slug' => $blockField['slug'],
                    'namespace' => $blockField['namespace'],
                    'type' => $blockField['type'],
                    'locked' => 0,
                    'config' => $blockField['config'],
                ]);
            }

            foreach ($blockField['streams'] as $stream) {
                $typeStream = $this->streamRepository->findBySlugAndNamespace($stream . '_blocks', 'blocks');

                if ($typeStream && !$this->assignments->findByStreamAndField($typeStream, $field)) {
                    $this->assignments->create([
                        'stream_id' => $typeStream->getId(),
                        'field_id' => $field->getId(),
                        'translatable' => $blockField['translatable']
                    ]);
                }
            }
        }
    }
}
