$('.add-ajax-address').on('click', function () {
    resetForm();
    //Set Create Form Action
    $("#cart-address").attr("action", '/profile/adress/ajaxCreate');

    //Set Default Country And List City
    $('select[name="country"]').val(default_country)
    if (default_country != "") {
        var cat = default_country;
        var level = 1;
        var name = 'city';
        Locations(cat, level, name);
    }

})

$("#cart-address").submit(function (e) {

    e.preventDefault(); // avoid to execute the actual submit of the form.
    var form = $(this);
    var url = form.attr('action');

    $.ajax({
        type: "POST",
        url: url,
        data: form.serialize(), // serializes the form's elements.
        success: function (response) {
            console.log(response)
            if (response.status == "success") {
                window.location.reload();
                $('.edit-this-address').show();
            } else if (response.status == "updated") {
                window.location.reload();
            } else {
                alert(response.msg)
            }
        }
    });
});

$('#paymentForm').submit(function (e) {
    let inputs = [
        {
            'input': $('input[name="license"]:checked').val(),
            'message': licenceRequiredMsg,
        },
        {
            'input': $('input[name="pay_type"]:checked').val(),
            'message': paymentRequiredMsg,
        },
        {
            'input': $('select[name="cart_option__site_select"]').val(),
            'message': siteRequiredMsg,
        },
        {
            'input': $('input[name="bill_address"]').length,
            'message': addressRequiredMsg,
        },
        {
            'input': $('input[name="bill_address"]:checked').length,
            'message': addressRequiredMsg,
        },
    ];

    checkInput(e, inputs)
})

function checkInput(e, inputs = []) {
    $.each(inputs, function(index, element) {
        if (!element.input) {
            e.preventDefault();

            Swal.fire({
                icon: 'warning',
                title: element.message,
                toast: true,
                position: 'top-end',
                timerProgressBar: true,
                showConfirmButton: false,
                timer: 1500
            })
        }
    })
/*

*/
}

$(document).ready(function () {
    if (!$('input[name="bill_address"]').length) {
        $('#addAddress').modal('show')
    }
});

//Edit Address Modal Get Field Value
$('.edit-this-address').on('click', function () {
    var edit_address_id = $(this).data('id');

    if (edit_address_id) {
        resetForm();

        //Set Update Form Action
        $("#cart-address").attr("action", '/profile/adress/ajaxUpdate/' + edit_address_id);

        //Get Address Detail
        crudAjax({"id": edit_address_id}, '/profile/adress/ajaxDetail', 'POST', function (callback) {
            var address_detail = callback.data;
            var address_field = ['company', 'tax_office', 'tax_number', 'adress_name', 'adress_gsm_phone', 'adress_first_name', 'adress_last_name'];

            //Each Value for Fields
            $.each(address_field, function (index, field) {
                $('input[name="' + field + '"]').val(address_detail[field])
            });

            var iti = intlTelInput(document.querySelector("input[name='adress_gsm_phone']"), {
                setNumber: address_detail.adress_gsm_phone
            })
            $('textarea[name="adress_content"]').html(address_detail.adress_content)

            changeSelect('country', address_detail.country_id)

            //Get City Options
            var cat = address_detail.country_id ?? default_country
            var level = 1;
            var name = 'city';
            Locations(cat, level, name);

            //Get District Options
            var selectedCity = new Promise(function (resolve) {

                changeSelect('city', address_detail.city)

                var cat = address_detail.city;
                var level = 2;
                var name = 'district';
                Locations(cat, level, name);
                resolve();
            });
            //Selected District
            selectedCity.then(function (categories_list) {
                changeSelect('district', address_detail.district)
            })

        })
        //Open Edit Address Modal
        $('#addAddress').modal('show')
    }
})

function resetForm() {
    $("#cart-address").trigger("reset");
    $("#cart-address").find("textarea").html('');
    $('select[name="district"]').html('')

}

function changeSelect(elementName, id) {
    let element = $('select[name="' + elementName + '"]');

    element.val(id)
        .parent()
        .find('.selected')
        .removeClass('selected focus');
    element.parent().find('.list li[data-value="' + id + '"]')
        .addClass('selected focus');
    element.parent().find('.current').text(element.parent().find('.list li[data-value="' + id + '"]').text())

}

$('#contractBtn').on('click', () => {
    let cart = $('input[name="cart"]').val(),
        page = $('input[name="refund_page"]').val(),
        delivery_address = $('select[name="delivery_address"]').val(),
        bill_address = $('select[name="bill_address"]').val(),
        pay_type = $('select[name="pay_type"] option:selected').text();

    crudAjax({
        'cart': cart,
        'page': page,
        'delivery_address': delivery_address,
        'bill_address': bill_address,
        'pay_type': pay_type,
    }, `/contract-page`, 'GET', (callback) => {
        $('#contractModal .modal-body').html('');
    }).then((callback) => {
        $.each(callback, function (key, value) {
            $('#contractModal .modal-body').append(
                `<div class="accordion" id="accordionExample">
                          <div class="card">
                            <div class="card-header" id="headingOne">
                              <h2 class="mb-0">
                                <button class="btn btn-link" type="button" data-toggle="collapse" data-target="#${key}" aria-expanded="true" aria-controls="${key}">
                                  ${value.store_name}
                                </button>
                              </h2>
                            </div>

                            <div id="${key}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample">
                              <div class="card-body">
                                ${value.content}
                              </div>
                            </div>
                          </div>
                        </div>`
            )
        })
    })
})
