function phoneMask(fields) {
    var country = document.getElementById('default-phone-country')
        ? document.getElementById('default-phone-country').innerText : null;
    var inputQueries = document.querySelectorAll(fields);
    inputQueries.forEach(function (inputQuery, key) {
        var iti = intlTelInput(inputQuery, {
            class: "form-control",
            initialCountry: "auto",
            geoIpLookup: function (success, failure) {
                $.get("https://ipinfo.io", function () {
                }, "jsonp").always(function (resp) {
                    var countryCode = country ? country : (resp && resp.country) ? resp.country : "";
                    success(countryCode);
                })
            }
        })
    });
}

function controlNumber(inputQuery) {
    var iti = intlTelInput(inputQuery, {
        hiddenInput: inputQuery.getAttribute('name'),
        class: "form-control",
        initialCountry: "auto",
        geoIpLookup: function (success, failure) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = (resp && resp.country) ? resp.country : "";
                success(countryCode);
            })
        }
    })

    return iti.isValidNumber();
}
